/**
 * 建设指挥 
 * 在建站点弹窗
 * 土建形象进度 
 * 3.0
 * 处理数据
 */

import { civilEngineeringDetailsTableData, civilEngineeringTableData } from "../../data/table/stationPopupData";
import { change, getPopupMoreData } from "../../dataPackage/inBackOut";


/**
 * 土建形象进度基础数据
 * @param line 线路名称
 * @param site 站点名称
 * @returns civilEngineering: { site:"站点名称", state:"站点状态", data:[{数据列表}, ...... ]}
 * data:[{
 *      region:"区域名称",
 *      normalCompletion:正常完成数量,
 *      normalDelay:正常延误数量,
 *      generalDelay:一般延误数量数量,
 *      seriousDelay:严重延误数量,
 *      regionNum:"工序编号"
 * }, ...... ]
 */
export async function getCivilEngineering(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = civilEngineeringTableData();
    
    //"线路", "站点名称", "站点状态", "区域", "正常完成", "正常延误", "一般延误", "严重延误"
    let data = change(["line", "site", "state", "region", "normalCompletion", "normalDelay", "generalDelay", "seriousDelay", "regionNum"], tableData["土建形象进度数据"].bodyList );

    let conf = ["region", "normalCompletion", "normalDelay", "generalDelay", "seriousDelay", "regionNum"];
    
    let civilEngineering = getPopupMoreData(line, data, conf);

    let result = {"civilEngineering": civilEngineering[site]}

    res.send(result);

    return result;
}


/**
 * 土建形象进度
 * 工序完成情况
 * @param regionNum 工序编号
 * @returns details: [{ name:"工序名称", dataList:[{数据列表}, ...... ] }]
 * dataList:[{
 *      constructionProcess:"施工工序",
 *      total:总量,
 *      weeklyPlan:周计划工作量,
 *      weeklyCompletion:周完成工作量,
 *      weeklyRatio:"周完成比例",
 *      completionStatus:"完成状态", 【正常完成、正常延误、一般延误、严重延误】
 *      totalCompletion:"总完成工作量",
 *      totalProportion:"总完成比例",
 *      incompleteReason:"未完成原因",
 * }, ...... ]
 * 没有数据的字段不显示，数据为0正常显示
 */
export async function getCivilEngineeringDetails(req, res) {
    let regionNum = req.query.regionNum || "17号线西岑站A区";
    let tableData = civilEngineeringDetailsTableData();

    let result:any = {};

    let details:any = {};
    for (let key in tableData) {
        if (regionNum == key) {
            //"施工工序", "总量", "周计划工作量", "周完成工作量", "周完成比例", "完成状态", "总完成工作量", "总完成比例", "未完成原因"
            let data = change(["region", "constructionProcess", "total", "weeklyPlan", "weeklyCompletion", "weeklyRatio", "completionStatus", "totalCompletion", "totalProportion", "incompleteReason"], tableData[key].bodyList );
        
            let conf = ["constructionProcess", "total", "weeklyPlan", "weeklyCompletion", "weeklyRatio", "completionStatus", "totalCompletion", "totalProportion", "incompleteReason"];
        
            data.forEach(item => {
                let detailsData = {};
                if (!details[item.region]) details[item.region] = [];

                for (let name = 0; name < conf.length; name++) {
                    detailsData[conf[name]] = item[conf[name]];
                }
                details[item.region].push(detailsData);
            });

        }
    }

    let detailsList = [];
    for (let key in details) {
        detailsList.push({name: key, dataList: details[key]})
    }

    result["details"] = detailsList;
    
    res.send(result);

    return result;
}