import { readFolderData } from "../data/interface/writeJson";
import { lineTableData, planningPeriodTableData, yearTableData } from "../data/table/publicData";
import { change } from "../dataPackage/inBackOut";
import { stringListPackage } from "../dataPackage/inFrontOut";
import { getStringOut } from "../dataPackage/out";
const path = require('path');


export function getLine(req, res) {
    let excelData = lineTableData();
    
    let ret:any = {};
             
    ret['line'] = getStringOut("线路", excelData['选择线路'].dataList);

    res.send(ret);
}


export function getLineJson(req, res) {
    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), "res/车站坐标json");
    // let url = "";
    let lineData = readFolderData(url);
    
    let ret:any = {};
             
    ret['lineJson'] = lineData;

    res.send(ret);
}


/**年份 */
export function getYear(req, res) {
    let excelData = yearTableData();

    let ret:any = {};

    let nfPackageData = stringListPackage(excelData['下拉年份'].dataList);
    ret['year'] = getStringOut('下拉年份', nfPackageData);
                  
    res.send(ret);
}


/**
 * 规划期类型对应线路
 */
export function getPlanningPeriod(req, res) {
    let excelData = planningPeriodTableData();

    let ret:any = {};
    let data = change(["type", "line"], excelData['规划期类型对应线路'].bodyList);

    let typeList = [];
    data.forEach( item => {
        if(!typeList[item.type]) typeList[item.type] = []
        typeList[item.type].push(item.line);
    })

    let planningPeriodDataList = [];
    for (let key in typeList) {
        planningPeriodDataList.push({key:"文本", value: key});
    }

    ret['planningPeriod'] = {title: "规划期", dataList: planningPeriodDataList};
                  
    res.send(ret);
}


/**
 * 根据规划期获取线路
 * @param req 
 * @param res 
 */
export function getLineByPlanningPeriod(req, res) {
    let planningPeriod = req.query.planningPeriod || "三期规划调整";
    let excelData = planningPeriodTableData();

    let ret:any = {};
    let data = change(["type", "line"], excelData['规划期类型对应线路'].bodyList);

    let typeList = [];
    data.forEach( item => {
        if(!typeList[item.type]) typeList[item.type] = ["全网"]
        typeList[item.type].push(item.line);
    })

    let lineData = typeList[planningPeriod];
    let lineDataList = [];

    lineData.forEach( info=> {
        lineDataList.push({key: "文本", value: info});
    })

    ret['line'] = {title: "根据规划期选择线路", dataList: lineDataList};
                  
    res.send(ret);
}