/**
 * 建设指挥 质量安全指标面板 3.5  逻辑
 * 处理数据
 */

import { currentRiskDefault, currentRiskDetailDefault, significantRiskDefault } from "../../config/defaultConfig";
import { QUALITY } from "../../config/titleEnum";
import { getQualitySafetyPanel } from "../../data/interface/qualitySafetyPanel";
import { keyValuePackage } from "../../dataPackage/inFrontOut";
import { getOnceYBarChartOut } from "../../dataPackage/out";


/**
 * 重大风险分布
 * @param req 
 * @param res 
 */
 export async function getFatality(req, res) {
    let line = req.query.line || "全网";

    let table = await getQualitySafetyPanel();

    let totalRisk = [];
    let level1Risk = [];

    let fatalityTable = table.significantRisk[line] || significantRiskDefault;
    for (let key in fatalityTable) {
        let {riskTotal, level1MajorRisks, secure, control, focus} = fatalityTable[key];

        totalRisk.push({key, value: riskTotal, unit:""});
        level1Risk.push({key, value: level1MajorRisks, unit:""});
    }
    
    let fatalityPackageData = {dataInfo: {"风险总数": totalRisk, "一级重大风险": level1Risk}, xUnit: "", yUnit: ""};

    let result:any = {};
    result["title"] = QUALITY.重大风险分布;
    result['fatality'] = getOnceYBarChartOut('重大风险分布', fatalityPackageData);
 
    res.send(result);
}


/**
 * 当前风险节点
 * @param req 
 * @param res 
 */
export async function getRisk(req, res) {
    let line = req.query.line || "全网";
    if (line == "全网") line = "全线网";

    let result:any = {};

    result["title"] = QUALITY.当前风险节点;

    let table = await getQualitySafetyPanel();

    let data = table.currentRisk[line] || currentRiskDefault;

    if (!data) {
        result['jkbx'] = {title: "基坑变形",dataList: {"key": "基坑变形","value": 0}};
        result['dcssl'] =  {title: "地层损失率",dataList: {"key": "地层损失率","value": 0}};
        result['ptddbcx'] =  {title: "旁通道地表沉降",dataList: {"key": "旁通道地表沉降","value": 0}};
    } else {
        let {outShapeValue, bottomLoseRate, dbcjVariable} = data;
        result['jkbx'] = {title: '基坑变形', dataList: {key:"基坑变形", value:outShapeValue}};
        result['dcssl'] = {title: '地层损失率', dataList: {key:"地层损失率", value:bottomLoseRate}};
        result['ptddbcx'] = {title: '旁通道地表沉降', dataList: {key:"旁通道地表沉降", value:dbcjVariable}};
        
        if (!outShapeValue) result['jkbx'] = {title: "基坑变形",dataList: {"key": "基坑变形","value": 0}};
        if (!bottomLoseRate) result['dcssl'] =  {title: "地层损失率",dataList: {"key": "地层损失率","value": 0}};
        if (!dbcjVariable) result['ptddbcx'] =  {title: "旁通道地表沉降",dataList: {"key": "旁通道地表沉降","value": 0}};
    }
    
    /**
     * 详细节点数据
     */
    
    if(line == "全线网") line = "全网";
    let detailData = table.currentRiskDetail[line] || currentRiskDetailDefault;
    if (!detailData) {
        result["jkxxsj"] = {title: "基坑详细数据", dataList: [{key: "基坑总数", value: 0}, {key:"当前数量", value: 0}]};
        result["qjxxsj"] = {title: "区间详细数据", dataList: [{key: "区间总数", value: 0}, {key:"当前数量", value: 0}]};
        result["ptdxxsj"] = {title: "旁通道详细数据", dataList: [{key: "旁通道总数", value: 0}, {key:"当前数量", value: 0}]};
    } else {
        let {pit, interval, superMajorBridge, pitCount, intervalCount, superMajorBridgeCount} = detailData;
        result["jkxxsj"] = {title: "基坑详细数据", dataList: [{key: "基坑总数", value: pitCount}, {key:"当前数量", value: pit}]};
        result["qjxxsj"] = {title: "区间详细数据", dataList: [{key: "区间总数", value: intervalCount}, {key:"当前数量", value: interval}]};
        result["ptdxxsj"] = {title: "旁通道详细数据", dataList: [{key: "旁通道总数", value: superMajorBridgeCount}, {key:"当前数量", value: superMajorBridge}]};
    }
    
    res.send(result);
}


/**
 * 工程安全状态
 * @param req 
 * @param res 
 */
export async function getEngineering(req, res) {
    let line = req.query.line || "全网";
    if (line == "全部 ")line == "全网";

    let table = await getQualitySafetyPanel();

    let result = {};
    
    result["title"] = QUALITY.工程安全状态;

    let fatalityTable = table.significantRisk[line] || significantRiskDefault;

    for (let key in fatalityTable) {
        let {riskTotal, level1MajorRisks, secure, control, focus} = fatalityTable[key];

        let title = `${key}风险期数量`;
        let value = secure + control + focus || 0;
        let packageData = {title, dataList: {key:`风险期数量`, value} };

        let onceList = [
            {rate:100, key:`安全`, value:secure },
            {rate:100, key:`风险可控`, value:control },
            {rate:100, key:`重点关注`, value:focus },
        ];
        let oncePackage = keyValuePackage(onceList);
        let descPackageData = {title: `${key}详细数据`, dataList: oncePackage};

        switch(key) {
            case "基坑":
                result["jkRiskNum"] = packageData;
                result["jkDetailedData"] = descPackageData;
            break;
            case "区间":
                result["dgqjRiskNum"] = packageData;
                result["dgqjDetailedData"] = descPackageData;
            break;
            case "旁通道":
                result["ptdRiskNum"] = packageData;
                result["ptdDetailedData"] = descPackageData;
            break;
        }

    }



    // for (let key in table ) {
    //     let {allCount,  allRisks,  count, risks} = descData(table[key].bodyList, line);
    //     let value = line == "全线网" ? allRisks : risks;
    //     let title = `${key}风险期数量`;
        
    //     let packageData = {title, dataList: {key:`风险期数量`, value} };
    //     switch(key) {
    //         case "基坑":result["jkRiskNum"] = packageData;break;
    //         case "盾构区间":result["dgqjRiskNum"] = packageData;break;
    //         case "旁通道":result["ptdRiskNum"] = packageData;break;
    //     }
    //     let {control, focus, secure } = getFXQData(table[key].bodyList, line);

    //     let onceList = [
    //         {rate:100, key:`安全`, value:line == secure },
    //         {rate:100, key:`风险可控`, value:line == control },
    //         {rate:100, key:`重点关注`, value:line == focus },
    //     ];

    //     let oncePackage = keyValuePackage(onceList);
    //     let descPackageData = {title: `${key}详细数据`, dataList: oncePackage};
    //     // descPackageData.dataList.forEach(info => {
    //     //     info["num"] = info.value;
    //     // })
    //     switch(key) {
    //         case "基坑":result["jkDetailedData"] = descPackageData;break;
    //         case "盾构区间":result["dgqjDetailedData"] = descPackageData;break;
    //         case "旁通道":result["ptdDetailedData"] = descPackageData;break;
    //     }
    // }
    res.send(result);
}


function descData(dataList, name) {
    let allCount = 0;
    let allRisks = 0;
    let count = 0;
    let risks = 0;
    dataList.forEach(subList => {
        allCount += subList[1];
        allRisks += subList[2]; 
        if (subList[0] == name) {
            count += subList[1];
            risks += subList[2]; 
        }
    });
    return { allCount,  allRisks,  count, risks};
}


function getFXQData(dataList, name) {
    let allControl = 0;
    let allFocus = 0;
    let allSecure = 0;
    let control = 0;
    let focus = 0;
    let secure = 0;

    dataList.forEach(subList => {
        allSecure += subList[3];
        allControl += subList[4];
        allFocus += subList[5];
        

        if (subList[0] == name) {
            secure += subList[3];
            control += subList[4];
            focus += subList[5];
        }
    });

    
    return { allControl, allFocus, allSecure, control, focus, secure };
}