/**
 * 建设指挥 计划进度指标面板  逻辑
 * 处理数据
 */

import { relocationTableData, prophaseTableData, scheduleTableData, milestoneTableData } from "../../data/table/constructData";
import * as defaultConfig from '../../config/defaultConfig';
import { change } from "../../dataPackage/inBackOut";
import { PLANNEDPROGRESS } from "../../config/titleEnum";


/**
 * 获取详细数据
 * @param data 
 * @param defaultData 
 * @param conf 
 * @param line 
 * @returns 
 */
function getProphaseDetailData(data, defaultData, conf, line) {
    let dataMap = {"全网":{"data":{}, "total":0}};
    data.forEach(item => {
        let dataLine = item.line;

        if (!dataMap[dataLine]) dataMap[dataLine] = {data:{}, total:0 };
        dataMap[dataLine]["total"] = item.total;
        
        for (let name = 0; name < conf.length; name++) {
            let plan = 0;
            let complete = 0;
            for (let key in item) {
                if (key.search(conf[name]) > -1) {
                    plan = item[conf[name]+"计划数"];
                    complete = item[conf[name]+"完成数"];
                    if (!dataMap[dataLine]["data"][conf[name]]) dataMap[dataLine]["data"][conf[name]] = {plan:0, complete:0};
                    if (!dataMap["全网"]["data"][conf[name]]) dataMap["全网"]["data"][conf[name]] = {plan:0, complete:0};
                }
            }
            dataMap[dataLine]["data"][conf[name]]["plan"] += plan || 0;
            dataMap[dataLine]["data"][conf[name]]["complete"] += complete || 0;

            dataMap["全网"]["data"][conf[name]]["plan"] += plan || 0;
            dataMap["全网"]["data"][conf[name]]["complete"] += complete || 0;
            
        }
        
    });

    for (let key in dataMap) {
        dataMap["全网"]["total"] += dataMap[key].total;
    }

    let result:any = {};
    result["completionStatus"] = {
        "total":0,
        "complete":0,//完成 
        "incomplete":0,//未完成
    };

    let onceLineData = dataMap[line] || defaultData;
    result["completionStatus"].total = onceLineData.total;
    let complete = 0;
    let scheduleList = [];
    for (let key in onceLineData.data) {
        let subComplete = onceLineData.data[key].complete;
        let subPlan = onceLineData.data[key].plan;
        complete += subComplete;
        scheduleList.push({
            name:key,
            total:subPlan,
            complete:subComplete,
            incomplete:subPlan-subComplete
        });
    }
    result["completionStatus"].complete = complete;
    result["completionStatus"].incomplete =  onceLineData.total - complete;
    result["scheduleList"] = scheduleList;

    return result;
}


/**
 * 2023年前期工作 证照办理
 * @param req 
 * @param res 
 */
export async function getProphase(req, res) {
    let line = req.query.line || "全网";

    let tableData = prophaseTableData();

    let data = change(["line","year","total","month","单体规划建设方案计划数","单体规划建设方案完成数","单体建设用地规划许可证计划数","单体建设用地规划许可证完成数","单体建设工程规划许可证计划数","单体建设工程规划许可证完成数","单体施工许可证计划数", '单体施工许可证完成数'], tableData["前期管理数据"].bodyList );

    /** dataMap结构{ "线":{ yearCount:0, data:{ "单体规划建设方案":{ plan:0, complete:0 } } } } */
    let conf = ["单体规划建设方案", "单体建设用地规划许可证", "单体建设工程规划许可证", "单体施工许可证"];
    let result:any = getProphaseDetailData(data, defaultConfig.ProphaseDefault, conf, line);
    result["title"] = PLANNEDPROGRESS.前期工作;
    res.send(result);
}


/**
 * 2023年前期工作 动迁腾地
 * @param req 
 * @param res 
 */
export async function getRelocation(req, res) {
    let line = req.query.line || "全网";
    let year = req.query.year || 2023;

    let tableData = relocationTableData();
    //"线路名称", "行政区", "总数", "已完成", "计划数"
    let data = change(["line", "administrativeDistrict", "total","complete","incomplete"], tableData["概览数据"].bodyList );

    /**基础数据 */
    let dataMap = {"全网": {}}; //总数
    let scheduleData = {"全网": {}}; //行政区
    let conf = ["total","complete","incomplete"];
    data.forEach(info => {
        for (let name = 0; name < conf.length; name++){
            if (line == "全网") {
                if (!dataMap["全网"][conf[name]]) dataMap["全网"][conf[name]] = 0;
                dataMap["全网"][conf[name]] += info[conf[name]] || 0;

                if (!scheduleData["全网"][info.administrativeDistrict]) scheduleData["全网"][info.administrativeDistrict] = {};
                if (!scheduleData["全网"][info.administrativeDistrict][conf[name]]) scheduleData["全网"][info.administrativeDistrict][conf[name]] = 0;
            
                scheduleData["全网"][info.administrativeDistrict][conf[name]] += info[conf[name]] || 0;
            } else {
                if (!dataMap[info.line]) dataMap[info.line] = {};
                if (!dataMap[info.line][conf[name]]) dataMap[info.line][conf[name]] = 0;

                dataMap[info.line][conf[name]] += info[conf[name]] || 0;


                if (!scheduleData[info.line]) scheduleData[info.line] = {};
                if (!scheduleData[info.line][info.administrativeDistrict]) scheduleData[info.line][info.administrativeDistrict] = {};
                if (!scheduleData[info.line][info.administrativeDistrict][conf[name]]) scheduleData[info.line][info.administrativeDistrict][conf[name]] = 0;

                scheduleData[info.line][info.administrativeDistrict][conf[name]] += info[conf[name]] || 0;
            }
        }

    });

    let result:any = {};

    result["completionStatus"] = dataMap[line] || defaultConfig.CompletionStatusDefault;


    let scheduleList = [];
    for (let key in scheduleData[line]) {
        scheduleList.push({name: key, dataList: scheduleData[line][key]})
    }

    result["scheduleList"] = scheduleList || defaultConfig.ScheduleListDefault;

    /**详细完成情况 */
    let scheduleTableData = change(["line", "site", "year","居民计划数","居民完成数","单位计划数","单位完成数","绿地计划数","绿地完成数"], tableData["动迁腾地详细"].bodyList );

    /**浮窗数据 */
    let detailMap = {}; 

    //"居民计划书","居民完成数","单位计划数","单位完成数","绿地计划数","绿地完成数"
    let detailConf = {
        "居民":["居民计划数", "居民完成数"],
        "单位":["单位计划数","单位完成数"],
        "绿地":["绿地计划数","绿地完成数"]
    };

    scheduleTableData.forEach(subList => {
        let dataYear = subList.year;
        let dataLine = subList.line;
        let dataSite = subList.line  + '-' + subList.site;

        if (!detailMap[dataYear]) detailMap[dataYear] = {'全网': {}};
        if (!detailMap[dataYear][dataLine]) detailMap[dataYear][dataLine] = {};

        if (!detailMap[dataYear][dataLine][dataSite]) detailMap[dataYear][dataLine][dataSite] = {};
        if (!detailMap[dataYear]['全网'][dataSite]) detailMap[dataYear]['全网'][dataSite] = {};

        for (let name in detailConf) {
            let plan = subList[detailConf[name][0]];
            let complete = subList[detailConf[name][1]];

            if (!detailMap[dataYear][dataLine][dataSite][name]) detailMap[dataYear][dataLine][dataSite][name] = {plan:0, complete:0, incomplete:0};
            if (!detailMap[dataYear]['全网'][dataSite][name]) detailMap[dataYear]['全网'][dataSite][name] = {plan:0, complete:0, incomplete:0};

            detailMap[dataYear][dataLine][dataSite][name]["plan"] = plan || 0;
            detailMap[dataYear][dataLine][dataSite][name]["complete"] = complete || 0;
            detailMap[dataYear][dataLine][dataSite][name]["incomplete"] = plan - complete || 0;

            detailMap[dataYear]['全网'][dataSite][name]["plan"] += plan || 0;
            detailMap[dataYear]['全网'][dataSite][name]["complete"] += complete || 0;
            detailMap[dataYear]['全网'][dataSite][name]["incomplete"] += plan - complete || 0;
        }

    });

    let detailList = [];
    for (let key in detailMap[year][line]) {
        detailList.push({name: key, dataList: detailMap[year][line][key]});
    }

    result["detailList"] = detailList;

    res.send(result);
}


/**
 * 2023年建设计划
 * @param req 
 * @param res 
 */
export async function getSchedule(req, res) {
    let line = req.query.line || "全网";

    let result:any = {};
    result["title"] = PLANNEDPROGRESS.建设计划;

    let excelData = scheduleTableData();
    
    let data = change(
        [
            "line","车站开工总数","车站开工已完成","车站开工未完成", "车站开工单位", 
            "车站结构封顶总数", '车站结构封顶已完成', '车站结构封顶未完成', "车站结构封顶单位",
            "盾构推进总数","盾构推进已完成","盾构推进未完成", "盾构推进单位",
            "旁通道总数", '旁通道已完成', '旁通道未完成', "旁通道单位",
            "轨道铺设总数", '轨道铺设已完成', '轨道铺设未完成', "轨道铺设单位",
            "出入口总数", '出入口已完成', '出入口未完成', "出入口单位"
        ], excelData["建设计划数据"].bodyList );

    let conf = ["车站开工", "车站结构封顶", "盾构推进", "旁通道", "轨道铺设", "出入口"]
    let dataMap = {"全网":{"data":{}}};
    
    data.forEach(item => {
        let dataLine = item.line;
        if (!dataMap[dataLine]) dataMap[dataLine] = {data:{} };

        for (let name = 0; name < conf.length; name++) {
            let plan = 0;
            let complete = 0;
            let inProgress = 0;
            let unit = "";
            for (let key in item){
                if (key.search(conf[name]) > -1) {
                    if (!dataMap[dataLine]["data"][conf[name]]) dataMap[dataLine]["data"][conf[name]] = {plan:0, complete:0, inProgress:0, unit: ""};
                    if (!dataMap["全网"]["data"][conf[name]]) dataMap["全网"]["data"][conf[name]] = {plan:0, complete:0, inProgress:0, unit: ""};
                    plan = item[conf[name]+"总数"];
                    complete = item[conf[name]+"已完成"];
                    inProgress = item[conf[name]+"未完成"];
                    unit = item[conf[name]+"单位"];
                }
            }
            
            dataMap[dataLine]["data"][conf[name]]["plan"] += plan;
            dataMap[dataLine]["data"][conf[name]]["complete"] += complete;
            dataMap[dataLine]["data"][conf[name]]["inProgress"] += inProgress;
            dataMap[dataLine]["data"][conf[name]]["unit"] = unit;

            dataMap["全网"]["data"][conf[name]]["plan"] += plan;
            dataMap["全网"]["data"][conf[name]]["complete"] += complete;
            dataMap["全网"]["data"][conf[name]]["inProgress"] += inProgress;
            dataMap["全网"]["data"][conf[name]]["unit"] = unit;
        }

    });
    
    let onceLineData = dataMap[line] || defaultConfig.ScheduleDefault;
    let complete = 0;
    let scheduleList = [];
    for (let key in onceLineData.data) {
        let subComplete = onceLineData.data[key].complete;
        let subPlan = onceLineData.data[key].plan;
        let subInProgress = onceLineData.data[key].inProgress;
        complete += subComplete;
        
        scheduleList.push({
            name:key,
            total:subPlan,
            complete:subComplete,
            incomplete:subInProgress,
            unit:onceLineData.data[key].unit
        });
    }

    result["scheduleList"] = scheduleList;

    let czDetailData = change(["line","year","计划数量","实际数量"], excelData["详细数据1"].bodyList );
    result["czkgDetailedData"] = getDetailData(czDetailData, line, defaultConfig.ScheduleDetailed);
    
    let cljdDetailData = change(["line","year","计划数量","实际数量"], excelData["详细数据2"].bodyList );
    result["cljgfdDetailedData"] = getDetailData(cljdDetailData, line, defaultConfig.ScheduleDetailed);
    
    let gjqjDetailData = change(["line","year","计划数量","实际数量"], excelData["详细数据3"].bodyList );
    result["dgtjDetailedData"] = getDetailData(gjqjDetailData, line, defaultConfig.ScheduleDetailed);

    let czjgfdDetailData = change(["line","year","计划数量","实际数量"], excelData["详细数据4"].bodyList );
    result["ptdDetailedData"] = getDetailData(czjgfdDetailData, line, defaultConfig.ScheduleDetailed);
    
    let ptdDetailData = change(["line","year","计划数量","实际数量"], excelData["详细数据5"].bodyList );
    result["gdpsDetailedData"] = getDetailData(ptdDetailData, line, defaultConfig.ScheduleDetailed);
    
    let crkDetailData = change(["line","year","计划数量","实际数量"], excelData["详细数据6"].bodyList );
    result["crkDetailedData"] = getDetailData(crkDetailData, line, defaultConfig.ScheduleDetailed);

    res.send(result);
}


/**
 * 获取建设计划浮窗数据
 * @param data 源数据
 * @param line 线路
 * @param defaultData 默认数据
 * @returns 
 */
function getDetailData(data, line, defaultData) {
    let result:any = {};

    let dataMap = {"全网":{data:{}}};

    data.forEach(subList => {
        let dataLine = subList.line;
        let dataYear = subList.year;
        if (!dataMap[dataLine]) dataMap[dataLine] = {data:{} };

        let plan = subList["计划数量"];
        let complete = subList["实际数量"];

        if (!dataMap[dataLine]["data"][dataYear]) dataMap[dataLine]["data"][dataYear] = {plan:0, complete:0};
        dataMap[dataLine]["data"][dataYear]["plan"] += plan;
        dataMap[dataLine]["data"][dataYear]["complete"] += complete;

        if (!dataMap["全网"]["data"][dataYear]) dataMap["全网"]["data"][dataYear] = {plan:0, complete:0};
        dataMap["全网"]["data"][dataYear]["plan"] += plan;
        dataMap["全网"]["data"][dataYear]["complete"] += complete;
    })

    let onceLineData = dataMap[line] || defaultData;
    let complete = 0;
    let scheduleList = [];
    for (let key in onceLineData.data) {
        let subComplete = onceLineData.data[key].complete;
        let subPlan = onceLineData.data[key].plan;
        complete += subComplete;
        scheduleList.push({
            name:key,
            total:subPlan,
            complete:subComplete
        });
    }
    result = scheduleList;

    return result;
}


export async function getMilestone(req, res) {
    let excelData = milestoneTableData();

    let result:any = {};
    // result["detailedList"] = [{title:"23号线首座车站开工",time:"2022-09-19", desc:"23号线江川东路站于2022-9-19首幅低下连续墙开工。", img:"http://192.168.0.71:40001/2005_01.jpg"},];

    result["title"] = PLANNEDPROGRESS.里程碑节点完成情况;

    result['detailedList'] = change(["title","time","desc","img"], excelData["里程碑节点完成情况"].bodyList );

    res.send(result);
}


