/**
 * 建设指挥 地图 4.0  逻辑
 * 处理数据
 */

import { lineConstructTableData, mapLineTableData, mapSiteJsonTableData, mapSiteTableData, mapTableData } from '../../data/table/constructData';
import { keyValuePackage, stringListPackage } from '../../dataPackage/inFrontOut';
import { getKeyValueOut, getStringOut } from '../../dataPackage/out';
import { change } from '../../dataPackage/inBackOut';
import { onceSheetBecomeOfblockData } from '../../util/analysisExcel';
import { readQualityData } from '../../data/interface/writeJson';
const path = require('path');


export function getMap(req, res) {
    let mapTable = mapTableData();
    let mapLineTable = mapLineTableData(); //线路
    let lineConstructTable = lineConstructTableData(); //建设里程碑

    let lineCoordinateTable = onceSheetBecomeOfblockData('建设指挥平台/建设指挥平台地图.xlsx', '线路坐标');
    let mapSiteTable = mapSiteTableData();

    let ret:any = {};

    let jcsjPackageData = keyValuePackage(mapTable['基础数据'].dataList);
    ret['jcsj'] = getKeyValueOut('基础数据', jcsjPackageData);

    let mapLineData = change(["name", "value", "key", "ygLine"], mapLineTable["地图线路"].bodyList);
    
    mapLineData.forEach( item => {
        let mapLineLocation = {};
        let {name, value, key, ygLine} = item;
        lineCoordinateTable.forEach( lineItem => {
            let {blockTitle, blockData} = lineItem;

            if (name == blockTitle) {
                for (let i = 1; i < blockData.length; i++) {
                    let key = blockData[i][0];
                    let value = blockData[i][1];
                    mapLineLocation[key] = value;
                }
                item["lineLocation"] = mapLineLocation;
            }
        })


        /**建设里程碑 */
        for (let key in lineConstructTable) {
            let lineConstructData = change(["time", "txt", "state"], lineConstructTable[key].bodyList);

            if (name == key) {
                item["constructList"] = lineConstructData;
            }
        }

        /**站点 */
        for (let siteKey in mapSiteTable) {
            let mapLineList = [];
            let siteCoordinate = {};
            let mapSiteData = change(["line", "lng", "lat", "height", "heading", "pitch", "roll"], mapSiteTable[siteKey].bodyList);
            
            mapSiteData.forEach( siteItem => {
                let {line, lng, lat, height, heading, pitch, roll} = siteItem;
                siteCoordinate = {lng, lat, height, heading, pitch, roll};
                mapLineList.push({line, location: siteCoordinate});
            })

            if (name == siteKey) {
                item["lineList"] = mapLineList;
            }
        }
        
    })
    

    let mapChangeLineData = [];
    mapLineData.forEach( data => {
        let changeData = data;
        if (data.lineList) changeData.value = data.lineList.length;
        mapChangeLineData.push(changeData);
    })

    // ret['dt'] = defaultConfig.mapDefault;
    ret['dt'] = {title: "线路列表", dataList: mapLineData};
            
    res.send(ret);
}


/**
 * 警报图片
 * @param req 
 * @param res 
 */
export function getEarlyWarning(req, res) {
    let ret:any = {};

    let earlyWarningData = [
        {
            type: 'warn',
            position: { //警报地址
                x: 6378135.248040633,
                y: -1491.9380484303829,
                z: 1850.1137940254034
            },
            img1: 'map/警报1.png',
            img2: 'map/警报2.png',
            img3: 'map/警报3.png',
            img4: 'map/警报4.png',
        },
        {
            type: 'normal',
            position: { //警报地址
                x: 6378136.284846687,
                y: 2563.7555093702085,
                z: -1815.1290212400193
            },
            img1: 'map/正常1.png',
            img2: 'map/正常2.png',
            img3: 'map/正常3.png',
            img4: 'map/正常4.png'
        }
    ];


    ret['earlyWarning'] = earlyWarningData;
    res.send(ret);
}


/**
 * 站点锚点坐标
 * @param req 
 * @param res 
 */
export function getSiteCoordinates(req, res) {
    let jsonname = req.query.jsonname || "19号线线路20221212.geojson";
    let siteJsonTable = mapSiteJsonTableData();

    let ret:any = {};

    let siteJsonDataList = siteJsonTable['坐标json数据'].dataList;
    ret['siteJson'] = {title: "线路对应坐标json", dataList: siteJsonDataList};

    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), "res/车站坐标json", jsonname);
    let data = readQualityData(url);
    let features = data["features"];
    let img = [];
    
    let siteCoordinates = [];
    features.forEach( item => {
        let {type, geometry, properties} = item;

        let geometryType = geometry["type"];
        let geometryCoordinates = geometry["coordinates"] || [0, 0, 0];
        let position = {
            x: geometryCoordinates[0],
            y: geometryCoordinates[1],
            z: geometryCoordinates[2]
        };
        

        let line = "";
        siteJsonDataList.forEach( item => {
            let { key, value } = item;
            if (value == jsonname) {
                line = key;
            }
        })

        if (geometryType == "Point") { 
            let warnTypeNum = Math.floor(Math.random() + 0.5);
            let warnType = "";
            if (warnTypeNum > 0) {
                warnType = "warn";
                img = ["map/警报1.png", "map/警报2.png", "map/警报3.png", "map/警报4.png"]
            } else {
                warnType = "normal";
                img = ["map/正常1.png", "map/正常2.png", "map/正常3.png", "map/正常4.png"];
            }
            siteCoordinates.push({line, site: properties["name"], warnType, position, img });      
        }
        
    })
    
    ret["siteCoordinates"] = siteCoordinates;
    res.send(ret);
}

