/**
 * 建设指挥 投资管控指标面板 4.0  逻辑
 * 处理数据
 */


import { INVEST } from "../../config/titleEnum";
import { contractWarningTableData } from "../../data/table/投资管控";
import { change } from "../../dataPackage/inBackOut";


export function getInvest(req, res) {
    let planningPeriod = req.query.planningPeriod || "三期规划调整"; //类型
    let line = req.query.line || "全网"; //线路
    let tableData = contractWarningTableData();

    let result:any = {};

    //规划期、线路、执行完成百分比、距计划偏差、年度用款计划、一月至今计划、一月至今累计完成、
    //完成百分比、年度用款计划、年度实际用款
    let paymentExecutionData = change(
        [
            "planningPeriod", "line", "executionCompletedProportion", "deviationFromPlan", "annualPaymentPlan1", "JanPlanToDate",
            "JanSoFarCummulativeComplete", "completionPercentage", "annualPaymentPlan2", "annualActualExpenditure"
    
        ], tableData["用款执行数据"].bodyList);

    let paymentExecution = {};
    let paymentExecutionConf = ["executionCompletedProportion", "deviationFromPlan", "annualPaymentPlan1", "JanPlanToDate", "JanSoFarCummulativeComplete"];
    
    let specialPurposeBonds = {};
    let specialPurposeBondsConf = ["completionPercentage", "annualPaymentPlan2", "annualActualExpenditure"];
    
    paymentExecutionData.forEach( item => {
        let dataType = item.planningPeriod;
        let dataLine = item.line;
        for (let name = 0; name < paymentExecutionConf.length; name++){
            if (!paymentExecution[dataType]) paymentExecution[dataType] = {
                "全网":{
                    "executionCompletedProportion":0, 
                    "deviationFromPlan":0, 
                    "annualPaymentPlan1":0, 
                    "JanPlanToDate":0, 
                    "JanSoFarCummulativeComplete":0
                }
            };
            if (!paymentExecution[dataType][dataLine]) paymentExecution[dataType][dataLine] = {
                "executionCompletedProportion":0, 
                "deviationFromPlan":0, 
                "annualPaymentPlan1":0, 
                "JanPlanToDate":0, 
                "JanSoFarCummulativeComplete":0
            };
            
            paymentExecution[dataType]["全网"][paymentExecutionConf[name]] += item[paymentExecutionConf[name]] || 0;
            paymentExecution[dataType][dataLine][paymentExecutionConf[name]] += item[paymentExecutionConf[name]] || 0;
        }

        for (let name = 0; name < specialPurposeBondsConf.length; name++) {
            if (!specialPurposeBonds[dataType]) specialPurposeBonds[dataType] = {
                "全网":{
                    "completionPercentage":0, 
                    "annualPaymentPlan2":0, 
                    "annualActualExpenditure":0
                }
            };
            if (!specialPurposeBonds[dataType][dataLine]) specialPurposeBonds[dataType][dataLine] = {
                "completionPercentage":0, 
                "annualPaymentPlan2":0, 
                "annualActualExpenditure":0
            };

            specialPurposeBonds[dataType]["全网"][specialPurposeBondsConf[name]] += item[specialPurposeBondsConf[name]] || 0;
            specialPurposeBonds[dataType][dataLine][specialPurposeBondsConf[name]] += item[specialPurposeBondsConf[name]] || 0;
        }

    })
    let planningPeriodData = paymentExecution[planningPeriod][line]; //--------报错
    for (let name = 0; name < paymentExecutionConf.length; name++){
        paymentExecution[planningPeriod][line][paymentExecutionConf[name]] = Math.round((planningPeriodData[paymentExecutionConf[name]] / 10000)*100)/100;
    }
    for (let name = 0; name < specialPurposeBondsConf.length; name++) {
        specialPurposeBonds[planningPeriod][line][specialPurposeBondsConf[name]] = Math.round((specialPurposeBonds[planningPeriod][line][specialPurposeBondsConf[name]] / 10000)*100)/100;
    }
    paymentExecution[planningPeriod]["全网"]["executionCompletedProportion"] = ((paymentExecution[planningPeriod]["全网"]["JanSoFarCummulativeComplete"]/paymentExecution[planningPeriod]["全网"]["annualPaymentPlan1"])*100).toFixed(2);
    // paymentExecution[planningPeriod]["全网"]["executionCompletedProportion"] = (paymentExecution[planningPeriod]["全网"]["executionCompletedProportion"] / Object.keys(paymentExecution[planningPeriod]).length).toFixed(2);
    result["paymentExecutionTitle"] = INVEST.用款执行;
    result["paymentExecution"] = paymentExecution[planningPeriod][line];

    specialPurposeBonds[planningPeriod]["全网"]["completionPercentage"] = ((specialPurposeBonds[planningPeriod]["全网"]["annualActualExpenditure"]/specialPurposeBonds[planningPeriod]["全网"]["annualPaymentPlan2"])*100).toFixed(2);
    // specialPurposeBonds[planningPeriod]["全网"]["completionPercentage"] = (specialPurposeBonds[planningPeriod]["全网"]["completionPercentage"] / Object.keys(specialPurposeBonds[planningPeriod]).length).toFixed(2);
    result["specialPurposeBondsTitle"] = INVEST.专项债;
    result["specialPurposeBonds"] = specialPurposeBonds[planningPeriod][line];

    res.send(result);
}