/**
 * 建设指挥 投资管控指标面板 合同预警弹窗 4.0  逻辑
 * 处理数据
 */

import { budgetwarningTableData, detailedTableData, estimateEarlyWarningTableData, targetcostTableData } from "../../data/table/投资管控";
import { change } from "../../dataPackage/inBackOut";
import { tablePackage } from "../../dataPackage/inFrontOut";
import { getKeyValueOut, getTableOut } from "../../dataPackage/out";


/**
 * 概算预警浮窗
 * @param req 
 * @param res 
 */
export function getEstimateEarlyWarning(req, res) {
    let tableData = estimateEarlyWarningTableData();
    let ret:any = {};
    let estimateEarlyWarning = change(["key", "value", "url"], tableData["概算预警"].bodyList);
    
    // let estimateEarlyWarning = getKeyValueOut("概算预警", tableData['概算预警'].dataList)

    ret["estimateEarlyWarning"] = estimateEarlyWarning;
    res.send(ret);
}




/**
 * 三级概算预警详情
 * 弃用
 * @param req 
 * @param res 
 */
export function getBudgetWarning(req, res) {
    let tableData = budgetwarningTableData();

    let ret:any = {};

    let budgetwarningTableDataList = tablePackage(tableData["三级概算预警"].headerList[0], tableData["三级概算预警"].bodyList);
    ret['budgetwarning'] = getTableOut( '三级概算预警', budgetwarningTableDataList);

    res.send(ret);
}


/**
 * 线路概算——目标成本
 * 弃用
 * @param req 
 * @param res 
 */
export function getTargetCost(req, res) {
    let warningNum = req.query.warningNum || "21号线一期1"; //预警编号 三级概算预警返回的数据
    let tableData = targetcostTableData();

    let ret:any = {};

    //"目标成本接近率", "概算", "目标成本", "动态成本"
    let targetcostTable = change(["targetCostRate", "financialEstimates", "financialEstimatesBudget", "targetCost", "targetCostBudget", "dynamicCost", "dynamicCostBudget"], tableData[warningNum].bodyList);
    
    let targetcostData = {};
    targetcostTable.forEach(item=> {
        targetcostData = item;
    })
    ret['title'] = "线路概算详情"; 
    ret['budgetwarning'] = targetcostData;

    res.send(ret);
}


/**
 * 线路概算——下拉选择类型
 * 弃用
 * @param req 
 * @param res 
 */
export function getType(req, res) {
    let warningNum = req.query.warningNum || "21号线一期1"; //预警编号 三级概算预警返回的数据

    let tableData = detailedTableData();

    let ret: any = {};

    let typeData = change(["type", "financialEstimates", "targetCost", "dynamicCost"], tableData[warningNum].bodyList);

    let typeList = [{key:"文本", value:"全部"}];
    typeData.forEach( item => {
        typeList.push({key:"文本", value:item.type});
    })
    ret["typeList"] = {title:"类型", dataList:typeList};

    res.send(ret);
}


/**
 * 线路概算——详情
 * 弃用
 * @param req 
 * @param res 
 */
export function getDetailed(req, res) {
    let warningNum = req.query.warningNum || "21号线一期1"; //预警编号 三级概算预警返回的数据
    let type = req.query.type || "全部"; //类型
    let tableData = detailedTableData();

    let ret: any = {};

    //"类型", "概算值", "目标成本", "动态成本"
    let financialEstimatesData = change(["name", "financialEstimates", "targetCost", "dynamicCost"], tableData[warningNum].bodyList);
    
    let detail = [];
    financialEstimatesData.forEach( item => {
        let dataType = item.name;
        if (type == "全部") {
            detail.push(item);
        } else if(dataType == type) {
            detail = [item];
        }
    })

    ret["detailed"] = detail;

    res.send(ret);
}