/**
 * 建设指挥 业财融合指标面板 4.0  逻辑
 * 处理数据 单位（亿元）
 */

import { estimateTableData, investmentStatusTableData } from "../../data/table/业财融合";
import { change } from "../../dataPackage/inBackOut";
import { BUSINESSFINANCE } from "../../config/titleEnum";
import { readQualityData } from "../../data/interface/writeJson";
import * as lineEnum from "../../config/lineEnum";
const path = require('path');


/**
 * 概算总数
 * @param req 
 * @param res 
 * @return 标题: title
 * @return 概算总数:estimatedTotal
 * @return 各线路概算:lineEstimate
 * @return 总体投资: overallInvestment
 * @return 支付完成情况: paymentSituation
 */
// export function getEstimate(req, res) {
//     let planningPeriod = req.query.planningPeriod || "全网"; //类型
//     let line = req.query.line || "全网"; //线路
//     let tableData = estimateTableData();

//     let result:any = {};
//     result["title"] = BUSINESSFINANCE.概算总数;

//     let data = change(["type", "line", "各线路概算金额", "投资完成", "投资计划", "用款累计执行", "用款计划"], tableData["概算总数数据"].bodyList );
    
//     let lineEstimateData = {};
//     let estimatedTotal = 0; //概算总数
//     let overallInvestment = {}; //总体投资
//     let paymentSituation = {}; //支付完成情况

//     let overallConf = ["投资完成", "投资计划"];
//     let paymentConf = ["用款累计执行", "用款计划"];

//     data.forEach(item => {
//         let dataType = item.type;
//         let dataLine = item.line;

//         /**全网总概算 */
//         estimatedTotal += item.各线路概算金额;

//         /**各线路概算 */
//         let estimatedValue = Math.round(item.各线路概算金额 * 100) / 100;
//         if (!lineEstimateData[dataType]) lineEstimateData[dataType] = {"全网":[]};
//         if (!lineEstimateData[dataType][dataLine]) lineEstimateData[dataType][dataLine] = [];
//         lineEstimateData[dataType][dataLine].push({key: item.line, value: Math.round(estimatedValue/10000 *100)/100});
//         lineEstimateData[dataType]["全网"].push({key: item.line, value: Math.round(estimatedValue/10000 *100)/100});

//         /**总体投资完成比 */
//         if (!overallInvestment[dataType]) overallInvestment[dataType] = {"全网":{}};
//         if (!overallInvestment[dataType][dataLine]) overallInvestment[dataType][dataLine] = {};
//         for (let name in overallConf) {
//             overallInvestment[dataType][dataLine][overallConf[name]] = item[overallConf[name]];
//             if (!overallInvestment[dataType]["全网"][overallConf[name]]) overallInvestment[dataType]["全网"][overallConf[name]] = 0;
//             overallInvestment[dataType]["全网"][overallConf[name]] += item[overallConf[name]];
//         }

//         /**支付完成情况 */
//         if (!paymentSituation[dataType]) paymentSituation[dataType] = {"全网":{}};
//         if (!paymentSituation[dataType][dataLine]) paymentSituation[dataType][dataLine] = {};
//         for (let name in paymentConf) {
//             paymentSituation[dataType][dataLine][paymentConf[name]] = item[paymentConf[name]];
//             if (!paymentSituation[dataType]["全网"][paymentConf[name]]) paymentSituation[dataType]["全网"][paymentConf[name]] = 0;
//             paymentSituation[dataType]["全网"][paymentConf[name]] += item[paymentConf[name]];
//         }

//     });

//     result["estimatedTotal"] = {key: "全网总概算（亿元）", value: Math.round(estimatedTotal/10000 * 100) / 100};
//     result["lineEstimate"] = lineEstimateData[planningPeriod][line];

//     let overallInvestmentData = overallInvestment[planningPeriod][line]; //投资完成、投资计划
//     let accumulatedProportion = Math.round((overallInvestmentData["投资完成"] / overallInvestmentData["投资计划"]*100 || 0 ) *100)/100;
//     result["overallInvestment"] = {
//         "proportion": overallInvestmentData["建设期累计占比"] == 0 ? 0 : accumulatedProportion || 0,//建设期累计占比=投资完成/投资计划
//         "complete": Math.round((overallInvestmentData["投资完成"] / 10000)*100)/100,
//         "plan": Math.round((overallInvestmentData["投资计划"] / 10000)*100)/100
//     };

//     let paymentSituationData = paymentSituation[planningPeriod][line]; //投资完成、投资计划
    
//     let percentComplete = Math.round((paymentSituationData["用款累计执行"] / paymentSituationData["用款计划"]*100 || 0 )*100)/100;
//     result["paymentSituation"] = {
//         "proportion": paymentSituationData["建设期累计完成比"] == 0 ? 0 : percentComplete || 0,//建设期累计完成比=用款累计执行/用款计划
//         "complete": Math.round((paymentSituationData["用款累计执行"] / 10000)*100)/100,
//         "plan": Math.round((paymentSituationData["用款计划"] / 10000)*100)/100
//     };


//     res.send(result);
// }



/**
 * 投资完成情况
 * @param req 
 * @param res 
 * @return  标题: title
 * @return 投资完成情况：annualAccumulation
 */
export async function getInvestmentCompletion(req, res) {
    let line = "全网"
    let tableData = investmentStatusTableData();

    // let data = change(["line", "年度累计", "年度累计动拆迁", "年度投资计划", "年度投资计划动拆迁"], tableData["年度投资情况数据"].bodyList );
    let data = change(["line", "一月至今累计完成", "一月至今累计动拆迁", "一月至今计划完成", "一月至今计划动拆迁", "年度投资计划", "年度投资计划动拆迁"], tableData["年度投资情况数据"].bodyList );
    let conf = ["一月至今累计完成", "一月至今累计动拆迁", "一月至今计划完成", "一月至今计划动拆迁", "年度投资计划", "年度投资计划动拆迁"];
    
    let result:any = {};
    result["title"] = BUSINESSFINANCE.投资完成情况;

    let annualAccumulation:any = {};

    data.forEach(item => {
        let dataLine = item.line;

        if (!annualAccumulation[dataLine]) annualAccumulation[dataLine] = {};
        if (!annualAccumulation["全部"]) annualAccumulation["全部"] = {};

        for (let name = 0; name < conf.length; name++) {
            for (let key in item) {
                if (key.search(conf[name]) > -1) {
                    annualAccumulation[dataLine][key] = item[key];

                    if (!annualAccumulation["全部"][key]) annualAccumulation["全部"][key] = 0;
                    annualAccumulation["全部"][key] += item[key];
                }
            }
        }
        
    });

    let defalut = {
        count:0, countRelocation:0, expected:0, expectedRelocation:0, proportion:0
    }
    let annualAccumulationData = annualAccumulation[line] || defalut;
    let annualProportion = Math.round((annualAccumulationData["一月至今累计完成"] / annualAccumulationData["年度投资计划"]*100 || 0 )*100)/100
    result["annualAccumulation"] = {
        "proportion": annualAccumulationData["年度累计占比"] == 0 ? 0 : annualProportion || 0,//年度累计占比=一月至今累计完成/年度投资计划
        "count": Math.round((annualAccumulationData["一月至今累计完成"] / 10000)*100)/100 || 0,//一月至今累计完成
        "countRelocation": Math.round((annualAccumulationData["一月至今累计动拆迁"] / 10000)*100)/100 || 0,//一月至今累计动拆迁
        "plan": Math.round((annualAccumulationData["一月至今计划完成"] / 10000)*100)/100 || 0,//一月至今计划完成
        "planRelocation": Math.round((annualAccumulationData["一月至今计划动拆迁"] / 10000)*100)/100 || 0,//一月至今计划动拆迁
        "expected": Math.round((annualAccumulationData["年度投资计划"] / 10000)*100)/100 || 0,//年度投资计划
        "expectedRelocation": Math.round((annualAccumulationData["年度投资计划动拆迁"] / 10000)*100)/100 || 0,//年度投资计划动拆迁
    };

    res.send(result);
}





export function getEstimate(req, res) {
    let planningPeriod = req.query.planningPeriod || "全网"; //规划期
    let line = req.query.line || "全网"; //线路
    let tableData = estimateTableData();

    let result:any = {};
    result["title"] = BUSINESSFINANCE.概算总数;

    let data = change(["type", "line", "各线路概算金额", "建设期累计完成", "总投资额", "建设期累计用款执行", "动态成本", "1月至今累计完成", "1月至今累计动拆迁", "1月至今计划", "1月至今计划动拆迁", "年度投资计划", "年度投资计划动拆迁"], tableData["概算总数数据"].bodyList );
    
    let lineEstimateData = {"全网":{"全网":[]}};
    let estimatedTotal = 0; //概算总数
    let overallInvestment = {"全网":{"全网":{"建设期累计完成":0, "总投资额":0}}}; //总体投资
    let paymentSituation = {"全网":{"全网":{"建设期累计用款执行":0, "动态成本":0}}}; //支付完成情况
    let annualAccumulation = {"全网":{"全网":{"1月至今累计完成":0, "1月至今累计动拆迁":0, "1月至今计划":0, "1月至今计划动拆迁":0, "年度投资计划":0, "年度投资计划动拆迁":0}}}; //2023投资完成情况

    let overallConf = ["建设期累计完成", "总投资额"];
    let paymentConf = ["建设期累计用款执行", "动态成本"];
    let annualAccumulationConf = ["1月至今累计完成", "1月至今累计动拆迁", "1月至今计划", "1月至今计划动拆迁", "年度投资计划", "年度投资计划动拆迁"];

    data.forEach(item => {
        let dataType = item.type;
        let dataLine = item.line;

        /**全网总概算 */
        estimatedTotal += item.各线路概算金额;

        /**各线路概算 */
        let estimatedValue = Math.round(item.各线路概算金额 * 100) / 100;
        lineEstimateData["全网"]["全网"].push({key: item.line, value: Math.round(estimatedValue/10000 *100)/100}); //规划期“全网”、线路“全网”

        if(!lineEstimateData["全网"][dataLine]) lineEstimateData["全网"][dataLine] = []; //规划期“全网”、线路“选择”
        lineEstimateData["全网"][dataLine].push({key: item.line, value: Math.round(estimatedValue/10000 *100)/100});

        if(!lineEstimateData[dataType]) lineEstimateData[dataType] = {"全网":[]}; //规划期“选择”、线路“全网”
        if(!lineEstimateData[dataType]["全网"]) lineEstimateData[dataType]["全网"] = [];
        lineEstimateData[dataType]["全网"].push({key: item.line, value: Math.round(estimatedValue/10000 *100)/100});

        if (!lineEstimateData[dataType][dataLine]) lineEstimateData[dataType][dataLine] = []; //规划期“选择”、线路“选择”
        lineEstimateData[dataType][dataLine].push({key: item.line, value: Math.round(estimatedValue/10000 *100)/100});

        /**总体投资完成比 */
        overallInvestment = getConfData(overallInvestment, overallConf, dataType, dataLine, item);

        /**支付完成情况 */
        paymentSituation = getConfData(paymentSituation, paymentConf, dataType, dataLine, item);

        /**2023投资完成情况 */
        annualAccumulation = getConfData(annualAccumulation, annualAccumulationConf, dataType, dataLine, item);

    });


    result["estimatedTotal"] = {key: "全网总概算（亿元）", value: Math.round(estimatedTotal/10000 * 100) / 100};
    result["lineEstimate"] = lineEstimateData[planningPeriod][line];

    let overallInvestmentData = overallInvestment[planningPeriod][line]; //建设期累计完成、总投资额
    let accumulatedProportion = Math.round((overallInvestmentData["建设期累计完成"] / overallInvestmentData["总投资额"]*100 || 0 ) *100)/100;
    result["overallInvestment"] = {
        "proportion": overallInvestmentData["建设期累计占比"] == 0 ? 0 : accumulatedProportion || 0,//建设期累计占比=建设期累计完成/总投资额
        "complete": Math.round((overallInvestmentData["建设期累计完成"] / 10000)*100)/100,
        "plan": Math.round((overallInvestmentData["总投资额"] / 10000)*100)/100
    };

    let paymentSituationData = paymentSituation[planningPeriod][line]; //投资完成、投资计划
    
    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), "res/投资管控指标面板json", "response_1686904561486.json");
    let dynamicCost = readQualityData(url);
    let extData = {"全网": 0}
    dynamicCost.forEach( item => {
        let name = item.name;
        let 动态成本 = item.extData.节点概算成本Model.动态成本;
        extData[name] = 动态成本;
        extData["全网"] += 动态成本;
    })
    
    for(let key in extData) {
        if (planningPeriod) {
            let lineEnumData = lineEnum.三期规划ENUM;
            for(let enumKey in lineEnumData) {
                if(key == enumKey) {
                    paymentSituationData["动态成本"] += extData[key];
                }
            }
        } else {
            if(key == line) {
                paymentSituationData["动态成本"] += extData[key];
            }
        }
        
    }
    let percentComplete = Math.round((paymentSituationData["建设期累计用款执行"] / paymentSituationData["动态成本"]*100 || 0 )*100)/100;
    result["paymentSituation"] = {
        "proportion": paymentSituationData["建设期累计完成比"] == 0 ? 0 : percentComplete || 0,//建设期累计完成比=建设期累计用款执行/动态成本
        "complete": Math.round((paymentSituationData["建设期累计用款执行"] / 10000)*100)/100,
        "plan": Math.round((paymentSituationData["动态成本"]/ 10000000000)*100)/100
    };

    let defalut = {
        count:0, countRelocation:0, expected:0, expectedRelocation:0, proportion:0
    }
    let annualAccumulationData = annualAccumulation[planningPeriod][line] || defalut;
    let annualProportion = Math.round((annualAccumulationData["1月至今累计完成"] / annualAccumulationData["年度投资计划"]*100 || 0 )*100)/100
    result["annualAccumulation"] = {
        "proportion": annualAccumulationData["年度累计占比"] == 0 ? 0 : annualProportion || 0,//年度累计占比=一月至今累计完成/年度投资计划
        "count": Math.round((annualAccumulationData["1月至今累计完成"] / 10000)*100)/100 || 0,//一月至今累计完成
        "countRelocation": Math.round((annualAccumulationData["1月至今累计动拆迁"] / 10000)*100)/100 || 0,//一月至今累计动拆迁
        "plan": Math.round((annualAccumulationData["1月至今计划"] / 10000)*100)/100 || 0,//一月至今计划完成
        "planRelocation": Math.round((annualAccumulationData["1月至今计划动拆迁"] / 10000)*100)/100 || 0,//一月至今计划动拆迁
        "expected": Math.round((annualAccumulationData["年度投资计划"] / 10000)*100)/100 || 0,//年度投资计划
        "expectedRelocation": Math.round((annualAccumulationData["年度投资计划动拆迁"] / 10000)*100)/100 || 0,//年度投资计划动拆迁
    };

    res.send(result);

}

function getConfData(data, conf, type, line, item) {
    if(!data["全网"][line]) data["全网"][line] = {}; //规划期“全网”、线路“选择”
    if(!data[type]) data[type] = {"全网": {}}; //规划期“选择”、线路“全网”
    if(!data[type][line]) data[type][line] = {}; //规划期“选择”、线路“选择”

    for (let name in conf) {
        data[type][line][conf[name]] = item[conf[name]];
        if(!data["全网"]["全网"][conf[name]]) data["全网"]["全网"][conf[name]] = 0;
        if(!data[type]["全网"][conf[name]]) data[type]["全网"][conf[name]] = 0;
        data["全网"]["全网"][conf[name]] += item[conf[name]];
        data[type]["全网"][conf[name]] += item[conf[name]];

        if(!data["全网"][line][conf[name]]) data["全网"][line][conf[name]] = 0;
        data["全网"][line][conf[name]] += item[conf[name]];
    }

    return data;
}




















