/**
 * 系统中使用的工具
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");
const md5 = require("md5");


/**
 * 生成任务草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}



/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}


/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 校验uscc是否合法
 * @param uscc 
 * @returns true/false 
 */
export function eccUscc(uscc:string) {
    let isSuccess = false;
    if (uscc.search(/^[A-Za-z0-9]{16}$/) > -1) isSuccess = true;
    else if (uscc.search(/^[A-Za-z0-9]{18}$/) > -1) isSuccess = true;
    return isSuccess;
}


/**
 * 获取绑定id
 * @param uscc 孵化器统一信用代码
 * @param bindUscc 被绑定的孵化器统一信用代码
 * @returns 
 */
export function getBindId(uscc:string, bindUscc:string) {
    return md5(`${uscc}${bindUscc}${Math.ceil(Math.random() *100)}`);
} 


/**
 * 获取今天开始时刻的时间戳  0时0分
 * @returns 
 */
export function getTodayMs() {
    let t =`${ moment().format("YYYY-MM-DD")} 00:00:00`;
    return new Date(t).valueOf();
}

/**
 * 获取这个月的开始时刻的时间戳  0时0分
 * @returns 
 */
export function getThisMonthMs() {
    let t =`${ moment().format("YYYY-MM")}-01 00:00:00`;
    return new Date(t).valueOf();
}


/**
 * 获取code的id
 * @param uscc 发送人的uscc
 * @param todaySendCount 今日发送次数
 * @returns ''
 */
export function getSMSCodeId(uscc:string, todaySendCount:number) {
    return md5(`${uscc}${todaySendCount}${new Date().valueOf()}`);
}


/**
 * 获取一个随机6位数的验证码
 * @returns 
 */
export function getSMSCode() {
    let code = ``;
    for (let i =0; i < 6; i++) {
        code += Math.floor(Math.random() * 10)
    }
    return code;
}


/**
 * 生成融资id
 * @param uscc 
 * @returns 
 */
export function getFinancingId(uscc) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() * 1000)}`);
}


/**
 * 生成创始团队成员id
 * @param uscc 
 * @param name 
 * @returns 
 */
export function getInitialTeamMemberId(uscc:string, name:string) {
    return md5(`${uscc}${name}${Math.ceil(Math.ceil(Math.random() * 1000000))}`);
}


/**
 * 生成 资讯id
 * @returns 
 */
export function getInformationId() {
    return md5(`${Math.ceil(Math.ceil(Math.random() * 1000000))}${new Date().valueOf() }${Math.ceil(Math.ceil(Math.random() * 1000000))}`);
}


/**
 * 获取上一个季度 年和季度
 * @returns declarationYear：数据填报年   declarationQuarter：数据填报季度
 */
export function getLastQuarter() {
    let thisYear = new Date().getFullYear();
    let thisQuarter = moment().quarter();//当月填报季度
    if ( (thisQuarter - 1) < 1 ) {
        thisYear = moment().subtract(1, 'years').year();
        thisQuarter = 4;
    } else thisQuarter = thisQuarter - 1;
    return {year:thisYear, quarter:thisQuarter};
}


export function getI18nRegisterId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf() }${Math.ceil(Math.ceil(Math.random() * 1000000))}`);
}


export function getPolicyBGImgId() {
    return `bgImg_${md5(`bgImg${new Date().valueOf()}${Math.ceil(Math.ceil(Math.random() * 1000000))}`)}`
}

/**
 * 获取随机id
 * @param uscc 
 */
export function randomId(tableName:string) {
    let randomStr = `${new Date().valueOf()}_${Math.ceil(Math.random()*100000)}`;
    return `${tableName}_${md5(randomStr)}`;
}

export function changeAddToString(address) {
    if (!address) return "";
    let str = "";
    address.forEach((item, index) => {
        if (index == 0 && item == "上海市") return;
        str += item;
    });
    return str;
}


export function getLabelId() {
    return `${md5(`label${new Date().valueOf()}${Math.ceil(Math.ceil(Math.random() * 10000))}${Math.ceil(Math.ceil(Math.random() * 10000))}`)}`
}


/**
 * 匹配企查查注册地址规则
 * @param original 
 * @returns 
 */
export function formatAddress(original) {
    // 匹配省/直辖市（支持"北京市"/"上海"等格式）
    const cityMatch = original.match(/^(.*?(?:省|市|自治区|特别行政区))/);
    const city = cityMatch ? cityMatch[1] : original.split(/[市区县]/)[0] + '市';
    
    // 匹配区级（支持"浦东新区"/"朝阳区"等格式）
    const districtMatch = original.match(/(?:省|市)(.*?(?:区|县|市|旗))/);
    const district = districtMatch ? districtMatch[1] : '';
    
    // 处理详细地址（自动保留原格式，仅修正明显错误）
    let detail = original.replace(city, '').replace(district, '')
        .replace(/(\d+)[幢栋](\d+)层/g, (_, num1, num2) => {
            const chineseNums = ['零', '一', '二', '三', '四', '五', '六', '七', '八', '九'];
            return `${chineseNums[parseInt(num1)] || num1}幢${num2}${num2.length === 1 ? '室' : ''}`;
        })
        .trim();
    
    return [city, city, district || city, detail || '地址不详'];
}


/**
 * 更完善的注册资本格式化函数
 * @param {string|number} value 注册资本值
 * @returns {string} 格式化后的注册资本字符串
 */
export function formatRegisteredCapital(value) {
    if (value === null || value === undefined) {
        return '';
    }
    
    // 如果输入是数字，转换为字符串
    if (typeof value === 'number') {
        value = value.toString();
    }
    
    // 确保是字符串类型
    if (typeof value !== 'string') {
        return String(value);
    }
    
    // 去除首尾空格
    value = value.trim();
    
    // 空字符串直接返回
    if (value === '') {
        return value;
    }
    
    // 特殊情况：如果是"-"或其他占位符，直接返回
    if (value === '-' || value === '--' || value === 'N/A' || value === 'null' || value === 'undefined') {
        return value;
    }
    
    // 判断是否已经包含单位
    // 定义常见单位列表
    const units = [
        '万元', '万', 'w', 'W',
        '元', '￥',
        '亿', '亿元',
        '美元', '美金', 'usd', 'USD',
        '人民币', 'RMB', 'CNY',
        '欧元', 'EUR', 'euro',
        '日元', 'JPY', 'yen',
        '港元', '港币', 'HKD',
        '英镑', 'GBP', 'pound'
    ];
    
    // 检查是否已包含单位（不区分大小写）
    const lowerValue = value.toLowerCase();
    for (const unit of units) {
        if (lowerValue.endsWith(unit.toLowerCase()) || 
            lowerValue.includes(unit.toLowerCase() + ' ') ||
            lowerValue.includes(' ' + unit.toLowerCase())) {
            return value; // 已包含单位，直接返回
        }
    }
    
    // 检查常见的外币符号
    const currencySymbols = ['¥', '￥', '$', '€', '£', '¥'];
    for (const symbol of currencySymbols) {
        if (value.includes(symbol)) {
            return value; // 包含货币符号，直接返回
        }
    }
    
    // 尝试提取纯数字部分
    // 移除所有非数字字符（除了小数点、逗号和负号）
    const numericString = value.replace(/[^0-9.,-]/g, '');
    
    // 检查是否包含有效数字
    if (numericString && /^-?\d[\d,]*\.?\d*$/.test(numericString)) {
        // 移除逗号并转换为数字
        const numericValue = parseFloat(numericString.replace(/,/g, ''));
        
        // 根据数值大小选择合适的单位
        if (!isNaN(numericValue)) {
            // 如果数字大于等于10000万（即1亿），可以考虑使用"亿元"
            if (numericValue >= 100000000) {
                const billionValue = (numericValue / 100000000).toFixed(2);
                // 去除末尾的.00
                const formatted = billionValue.replace(/\.00$/, '');
                return formatted + '亿元';
            } 
            // 如果数字大于等于1000，使用"万元"
            else if (numericValue >= 1000) {
                const tenThousandValue = (numericValue / 10000).toFixed(2);
                const formatted = tenThousandValue.replace(/\.00$/, '');
                return formatted + '万元';
            }
            // 否则直接添加"万元"
            else {
                // 如果是整数，不显示小数位
                if (Number.isInteger(numericValue)) {
                    return numericValue + '万元';
                } else {
                    return numericValue.toFixed(2).replace(/\.00$/, '') + '万元';
                }
            }
        }
    }
    
    // 如果无法解析为数字，但看起来像是金额（包含数字）
    if (/\d/.test(value)) {
        return value + '万元';
    }
    
    // 其他情况返回原值
    return value;
}


