/**
 * 资质证书
 */
import {Schema} from 'mongoose';
import { sasp } from '../db/mongo/dbInit';

const qualificationsSchema = new Schema({
    id:{type:String, index: true},
    uscc:{type:String, index: true},
    enterpriseName:String,
    name:String,//产品名称或者资质类别及等级
    type:String,//证书类型
    startDate:Number,//证书生效时间
    endDate:Number,//证书截止日期
    no:String,//证书编号
    typeDesc:String,//证书类型
    institutionList:String,//发证机构
    status:String,//证书状态
});

var qualificationsModel;
export function initModel(){
    qualificationsModel = sasp.model('qualifications', qualificationsSchema);
    qualificationsModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await qualificationsModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

export async function createOnce(param) {
    return await qualificationsModel.create(param);
}

export async function findOnce(param) {
    return await qualificationsModel.selectOnceData(param);
}

export async function findList(param) {
    return await qualificationsModel.find(param);
}

export async function removeMany(param) {
    return await qualificationsModel.deleteMany(param);
}

export async function addMany(params) {
    await qualificationsModel.insertMany(params);
}