/**
 * 活动
 */

import {Schema} from 'mongoose';
import {sasp} from '../db/mongo/dbInit';

const activitySchema = new Schema({
    id:{type:String, index:true}, //唯一标识
    title:String, //活动标题
    // state:{type:Number, default:1}, //活动状态 未开始、活动中、已结束 -- 移除state字段，根据startTime和endTime动态计算状态
    startTime:Number, //活动开始时间
    endTime:Number, //活动结束时间
    target:{type:[Number], default:[]}, //活动类型
    location:String, //活动地点
    desc:String, //活动详情
})


var activityModel;
export function initModel(){
    activityModel = sasp.model('activity', activitySchema);
    activityModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await activityModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 分页获取所有园区活动
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 在跟在谈活动列表
 */
export async function findActivityListToPage(selectParam, skipCount) {
    return await activityModel.find(selectParam).skip(skipCount).limit(10);
}


/**
 * 获取符合条件的活动数量
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
export async function findActivityCount(selectParam) {
    return await activityModel.find(selectParam).countDocuments();
}


/**
 * 获取符合条件的活动
 * @param selectParam 
 */
export async function findActivityByParam(selectParam) {
    return await activityModel.selectOnceData(selectParam);
}


/**
 * 获取符合条件的活动列表
 * @param selectParam 
 */
 export async function findActivityListByParam(selectParam) {
    return await activityModel.find(selectParam);
}


/**
 * 新增园区活动
 * @param param 
 * @returns 
 */
export async function createDataByParam(param) {
    return await activityModel.create(param);
}


/**
 * 删除园区活动
 * @param id 
 * @returns 
 */
export async function removeOneData(id:string) {
    return await activityModel.deleteOne({id});
}





