/**
 * 校验枚举工具
 * 
 */

import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "./bizError";


/**
 * 校验value是否符合传入的枚举
 * @param name 被掉用名称 用于输出异常日志
 * @param key 目标字段  用于输出异常日志
 * @param enumConf 目标枚举
 * @param value 目标值
 * 无返回 有异常直接报错
 */
export function eccEnumValue(name:string, key:string, enumConf, value:any) {
    let eccSuccess = true;
    if ( typeof value == 'number' ) {
        if (!enumConf[value] ) eccSuccess = false;
    } else if (Array.isArray(value)) {
        value.forEach(item => {
            if ( !enumConf[item] ) eccSuccess = false;
        });
    }
    
    if (!eccSuccess) throw new BizError(ERRORENUM.请完善信息, `${name} 下的 ${key} 字段值为 ${value} 不满足枚举范围`);
}


/**
 * 将枚举值转换成对应的枚举名(key)
 * @param enumConf 目标枚举
 * @param value 目标值
 * @returns string  返回字符串 如果传入多个枚举值，就拼接字符串
 */
export function changeEnumValue(enumConf, value:any) {
    if (!value) return '';
    if ( typeof value == 'number' ) {
        let str = enumConf[value];
        /** 特化处理 中文引号在枚举中不适用*/
        if (str == "_投资__孵化_类型") {
            str = str.replace("__","+");
            str = str.replace("_","“");
            str = str.replace("_","”");
        }
        if (str == "经营成本过高_场地成本或人员成本_" || str == "办公空间拓展_无合适办公空间_") {
            str = str.replace("_","(");
            str = str.replace("_",")");
        }
        if (str == "迁出孵化器_仍在张江" || str == "迁出张江_仍在浦东" || str == "迁出浦东_仍在上海") {
            str = str.replace("_",",");
        }
        if (str == "科技金融_风险投资_" || str == "科技金融_其他_" || str == "技术专家_法律专家_") {
            str = str.replace("_","(");
            str = str.replace("_",")");
        }
        return str
    }
    let str = "";
    value.forEach((item, index) => {
        let subStr = enumConf[item];
        /** 特化处理 中文引号在枚举中不适用*/
        if (subStr == "_投资__孵化_类型") {
            subStr = subStr.replace("__","+");
            subStr = subStr.replace("_","“");
            subStr = subStr.replace("_","”");
        }
        if (subStr == "经营成本过高_场地成本或人员成本_" || subStr == "办公空间拓展_无合适办公空间_") {
            subStr = subStr.replace("_","(");
            subStr = subStr.replace("_",")");
        }
        if (subStr == "迁出孵化器_仍在张江" || subStr == "迁出张江_仍在浦东" || subStr == "迁出浦东_仍在上海") {
            subStr = subStr.replace("_",",");
        }
        if (subStr == "科技金融_风险投资_" || subStr == "科技金融_其他_" || subStr == "技术专家_法律专家_") {
            subStr = subStr.replace("_","(");
            subStr = subStr.replace("_",")");
        }
        str += subStr;
        if (index == value.length-1) str+="";
        else str += ","
    });

    return str;
}


export function changeEnumManyValue(enumConf, value:any) {
    let list = [];
    value.forEach((item, index) => {
        let subStr = enumConf[item];
        /** 特化处理 中文引号在枚举中不适用*/
        if (subStr == "_投资__孵化_类型") {
            subStr = subStr.replace("__","+");
            subStr = subStr.replace("_","“");
            subStr = subStr.replace("_","”");
        }
        if (subStr == "经营成本过高_场地成本或人员成本_" || subStr == "办公空间拓展_无合适办公空间_") {
            subStr = subStr.replace("_","(");
            subStr = subStr.replace("_",")");
        }
        if (subStr == "迁出孵化器_仍在张江" || subStr == "迁出张江_仍在浦东" || subStr == "迁出浦东_仍在上海") {
            subStr = subStr.replace("_",",");
        }
        if (subStr == "科技金融_风险投资_" || subStr == "科技金融_其他_" || subStr == "技术专家_法律专家_") {
            subStr = subStr.replace("_","(");
            subStr = subStr.replace("_",")");
        }
        list.push(subStr);
    });

    return list;
}


/**
 * 根据枚举值反向获取名称
 * @param enumConf 
 * @param code 
 * @returns 
 */
export function changeEnumNameByCode(enumConf, code: string) {
    for (const [name, value] of Object.entries(enumConf)) {
        if (value === code) {
            return name;
        }
    }
    return '未知行业';
}



