/**
 * 管理后台 - 服务追踪
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as trackBiz from "../biz/track";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/track/list', checkAdminUserToken, asyncHandler(getTrackList));
    httpServer.post('/admin/track/add', checkAdminUserToken, asyncHandler(addTrack));
    httpServer.post('/admin/track/info', checkAdminUserToken, asyncHandler(getTrackInfo));
    httpServer.post('/admin/trackdetails/info', checkAdminUserToken, asyncHandler(getTrackDetailsInfo));
    httpServer.post('/admin/track/update', checkAdminUserToken, asyncHandler(updateTrack));
    httpServer.post('/admin/track/del', checkAdminUserToken, asyncHandler(delTrack));
    httpServer.post('/admin/track/output', checkAdminUserToken, asyncHandler(outPutTrackList));
}


/**
 * 服务追踪-列表
 * @param req 
 * @param res 
 */
async function getTrackList(req, res) {
    let reqConf = {name:'String', demand:'Number', trackType:'Number', page:'Number'};
    const NotMustHaveKeys = ['name', 'demand', 'trackType'];
    let {name, demand, trackType, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await trackBiz.trackList(name, demand, trackType, page);
    res.success(result);
}


/**
 * 服务追踪-新增
 * @param req 
 * @param res 
 */
async function addTrack(req, res) {
    let reqConf = {param:"Object"};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await trackBiz.trackCreate(param);
    res.success(result);
}


/**
 * 服务追踪-回显
 * @param req 
 * @param res 
 */
async function getTrackInfo(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await trackBiz.trackInfo(id);
    res.success(result);
}


/**
 * 服务追踪-回显
 * @param req 
 * @param res 
 */
async function getTrackDetailsInfo(req, res) {
    let reqConf = {tdid:"String"};
    let { tdid } = eccReqParamater(reqConf, req.body);

    let result = await trackBiz.trackDetailsInfo(tdid);
    res.success(result);
}


/**
 * 服务追踪-修改
 * @param req 
 * @param res 
 */
async function updateTrack(req, res) {
    let reqConf = {id:"String", param:"Object"};
    let { id, param } = eccReqParamater(reqConf, req.body);

    let result = await trackBiz.trackUpdate(id, param);
    res.success(result);
}


/**
 * 服务追踪-删除
 * @param req 
 * @param res 
 */
async function delTrack(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await trackBiz.trackDelete(id);
    res.success(result);
}


/**
 * 服务追踪-导出-每个跟进记录单独一行
 * @param req 
 * @param res 
 */
 async function outPutTrackList(req, res) {
    let reqConf = {name:'String', demand:'Number', trackType:'Number', id:'[String]'};
    const NotMustHaveKeys = ['name', 'demand', 'trackType', 'id'];
    let {name, demand, trackType, id} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await trackBiz.outPutTrackDetailsData(name, demand, trackType, id);
    res.success(result);
}





