/**
 * 管理后台 - 在谈在跟
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as negotiationBiz from "../biz/negotiation";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/negotiation/list', checkAdminUserToken, asyncHandler(getNegotiationList));
    httpServer.post('/admin/negotiation/add', checkAdminUserToken, asyncHandler(addNegotiation));
    httpServer.post('/admin/negotiation/info', checkAdminUserToken, asyncHandler(getNegotiationInfo));
    httpServer.post('/admin/negotiation/update', checkAdminUserToken, asyncHandler(updateNegotiation));
    httpServer.post('/admin/negotiation/list', checkAdminUserToken, asyncHandler(getNegotiationList));
    httpServer.post('/admin/negotiation/output', checkAdminUserToken, asyncHandler(outPutNegotiation));
}


/**
 * 在谈在跟-列表
 * @param req 
 * @param res 
 */
async function getNegotiationList(req, res) {
    let reqConf = {name:'String', industry:'[Number]', registrationStatus:'Number', primaryContact:'String', contactDepartment:'String', page:'Number'};
    const NotMustHaveKeys = ['name', 'industry', 'registrationStatus', 'primaryContact', 'contactDepartment'];
    let {name, industry, registrationStatus, primaryContact, contactDepartment, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await negotiationBiz.negotiationList(name, industry, registrationStatus, primaryContact, contactDepartment, page);
    res.success(result);
}


/**
 * 在谈在跟-新增
 * @param req 
 * @param res 
 */
async function addNegotiation(req, res) {
    let reqConf = {param:"Object"};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await negotiationBiz.negotiationCreate(param);
    res.success(result);
}


/**
 * 在谈在跟-回显
 * @param req 
 * @param res 
 */
async function getNegotiationInfo(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await negotiationBiz.negotiationInfo(id);
    res.success(result);
}


/**
 * 在谈在跟-修改
 * @param req 
 * @param res 
 */
async function updateNegotiation(req, res) {
    let reqConf = {id:"String", param:"Object"};
    let { id, param } = eccReqParamater(reqConf, req.body);

    let result = await negotiationBiz.negotiationUpdate(id, param);
    res.success(result);
}


/**
 * 在谈在跟-删除
 * @param req 
 * @param res 
 */
async function delNegotiation(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await negotiationBiz.negotiationDelete(id);
    res.success(result);
}


/**
 * 在谈在跟-导出
 * @param req 
 * @param res 
 */
 async function outPutNegotiation(req, res) {
    let reqConf = {name:'String', industry:'[Number]', registrationStatus:'Number', primaryContact:'String', contactDepartment:'String', id:'[String]'};
    const NotMustHaveKeys = ['name', 'industry', 'registrationStatus', 'primaryContact', 'contactDepartment', 'id'];
    let {name, industry, registrationStatus, primaryContact, contactDepartment, id} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await negotiationBiz.outPutNegotiationData(name, industry, registrationStatus, primaryContact, contactDepartment, id);
    res.success(result);
}





