/**
 * 管理后台 - 经营数据
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as manageBiz from "../biz/manage";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/manage/list', checkAdminUserToken, asyncHandler(getManageList));
    httpServer.post('/admin/manage/add', checkAdminUserToken, asyncHandler(addManage));
    httpServer.post('/admin/manage/info', checkAdminUserToken, asyncHandler(getManageInfo));
    httpServer.post('/admin/manage/update', checkAdminUserToken, asyncHandler(updateManage));
    httpServer.post('/admin/manage/del', checkAdminUserToken, asyncHandler(delManage));
    httpServer.post('/admin/manage/output', checkAdminUserToken, asyncHandler(outPutManageList));
}


/**
 * 经营数据-列表
 * @param req 
 * @param res 
 */
async function getManageList(req, res) {
    let reqConf = {name:'String', year:'Number', period:'Number', page:'Number'};
    const NotMustHaveKeys = ['name', 'year', 'period'];
    let {name, year, period, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await manageBiz.manageList(name, year, period, page);
    res.success(result);
}


/**
 * 经营数据-新增
 * @param req 
 * @param res 
 */
async function addManage(req, res) {
    let reqConf = {param:"Object"};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await manageBiz.manageCreate(param);
    res.success(result);
}


/**
 * 经营数据-回显
 * @param req 
 * @param res 
 */
async function getManageInfo(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await manageBiz.manageInfo(id);
    res.success(result);
}


/**
 * 经营数据-修改
 * @param req 
 * @param res 
 */
async function updateManage(req, res) {
    let reqConf = {id:"String", param:"Object"};
    let { id, param } = eccReqParamater(reqConf, req.body);

    let result = await manageBiz.manageUpdate(id, param);
    res.success(result);
}


/**
 * 经营数据-删除
 * @param req 
 * @param res 
 */
async function delManage(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await manageBiz.manageDelete(id);
    res.success(result);
}


/**
 * 经营数据-列表
 * @param req 
 * @param res 
 */
 async function outPutManageList(req, res) {
    let reqConf = {name:'String', year:'Number', period:'Number', id:'[String]'};
    const NotMustHaveKeys = ['name', 'year', 'period', 'id'];
    let {name, year, period, id} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await manageBiz.outPutManageData(name, year, period, id);
    res.success(result);
}





