/**
 * 管理后台 - 导入
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as importDataBiz from "../biz/importData";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/show/excelurl', checkAdminUserToken, asyncHandler(getExcelModelUrl));
    httpServer.post('/admin/show/updata', checkAdminUserToken, asyncHandler(upData));
}


async function getExcelModelUrl(req, res) {
    let reqConf = {excelType:'Number'};
    let {excelType} = eccReqParamater(reqConf, req.body);

    let result = await importDataBiz.excelUrl(excelType);
    res.success(result);
}



/**
 * 导入
 * @param req 
 * @param res 
 */
async function upData(req, res) {
    let reqConf = {list:'[Object]', excelType:'Number'};
    let {list, excelType} = eccReqParamater(reqConf, req.body);

    let result = await importDataBiz.upShowExcel(list, excelType);
    res.success(result);
}




