/**
 * 管理后台 - 用户
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as adminuserBiz from "../biz/adminuser";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/user/login', asyncHandler(login));
    httpServer.post('/admin/user/add', asyncHandler(AddAdminUser));
    httpServer.post('/admin/user/homepage', checkAdminUserToken, asyncHandler(getHomePage));
}


/**
 * 管理后台登录
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let userInfo = await adminuserBiz.login(loginId, pwd);
    res.success(userInfo);
}


/**
 * 用户-新增
 * @param req 
 * @param res 
 */
async function AddAdminUser(req, res) {
    let reqConf = {param:"Object"};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await adminuserBiz.adminUserCreate(param);
    res.success(result);
}


/**
 * 数据看板
 * @param req 
 * @param res 
 */
 async function getHomePage(req, res) {
    let result = await adminuserBiz.homePage();
    res.success(result);
}




