/**
 * 管理后台 - 园区活动
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as activityBiz from "../biz/activity";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/activity/list', checkAdminUserToken, asyncHandler(getActivityList));
    httpServer.post('/admin/activity/add', checkAdminUserToken, asyncHandler(addActivity));
    httpServer.post('/admin/activity/info', checkAdminUserToken, asyncHandler(getActivityInfo));
    httpServer.post('/admin/activity/update', checkAdminUserToken, asyncHandler(updateActivity));
    httpServer.post('/admin/activity/del', checkAdminUserToken, asyncHandler(delActivity));
    httpServer.post('/admin/activity/output', checkAdminUserToken, asyncHandler(outPutActivityList));
}


/**
 * 园区活动-列表
 * @param req 
 * @param res 
 */
async function getActivityList(req, res) {
    let reqConf = {title:'String', startTime:'Number', endTime:'Number', target:'[Number]', state:'Number', page:'Number'};
    const NotMustHaveKeys = ['title', 'startTime', 'endTime', 'target', 'state'];
    let {title, startTime, endTime, target, state, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await activityBiz.activityList(title, startTime, endTime, target, state, page);
    res.success(result);
}


/**
 * 园区活动-新增
 * @param req 
 * @param res 
 */
async function addActivity(req, res) {
    let reqConf = {param:"Object"};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await activityBiz.activityCreate(param);
    res.success(result);
}


/**
 * 园区活动-回显
 * @param req 
 * @param res 
 */
async function getActivityInfo(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await activityBiz.activityInfo(id);
    res.success(result);
}


/**
 * 园区活动-修改
 * @param req 
 * @param res 
 */
async function updateActivity(req, res) {
    let reqConf = {id:"String", param:"Object"};
    let { id, param } = eccReqParamater(reqConf, req.body);

    let result = await activityBiz.activityUpdate(id, param);
    res.success(result);
}


/**
 * 园区活动-删除
 * @param req 
 * @param res 
 */
async function delActivity(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await activityBiz.activityDelete(id);
    res.success(result);
}


/**
 * 园区活动-列表
 * @param req 
 * @param res 
 */
async function outPutActivityList(req, res) {
    let reqConf = {title:'String', startTime:'Number', endTime:'Number', target:'[Number]', state:'Number', id:'[String]'};
    const NotMustHaveKeys = ['title', 'startTime', 'endTime', 'target', 'state', 'id'];
    let {title, startTime, endTime, target, state, id} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await activityBiz.outPutActivityData(title, startTime, endTime, target, state, id);
    res.success(result);
}





