/**
 * 拆分返回结果配置
 * 使用场景：逻辑层中需要返回数据给客户端的地方
 * 限制：使用端不同不能共用一份配置
 */


/**
 * 使用端:   管理后台
 * 场景:     在谈在跟列表
 * 备注:     导出和列表共用一份配置
 */
export const negotiationListConfig = {
    id:{key:"标识"},
    name:{key:"企业名称"},
    industry:{key:"行业领域"},
    registrationStatus:{key:"推进/注册情况"},
    progressStatus:{key:"进展情况"},
    primaryContact:{key:"负责人/首谈人"},
    contactDepartment:{key:"对接部门"},
};


/**
 * 使用端:   管理后台
 * 场景:     企业库列表
 * 备注:     导出和列表共用一份配置
 */
export const enterpriseListConfig = {
    uscc:{key:"统一社会信用代码"},
    name:{key:"企业名称"},
    industry:{key:"行业领域[]"},
    logonTime:{key:"企业成立时间", changeDate:true},
    parkEntryTime:{key:"入驻园区年份", changeDate:true},
    leasedArea:{key:"租赁面积(㎡)"},
    labels:{key:"企业标签"},
    jingYingFanWei:{key:"经营范围"},
    RAS:{key:"登记状态"},
    zhuceziben:{key:"注册资本"},
    property:{key:"所属物业"},
    enterpriseNature:{key:"企业性质"},
    logonAddress:{key:"注册地址"},
    legalPerson:{key:"法人"},
    dianHua:{key:"联系电话"},
};


/**
 * 使用端:   管理后台
 * 场景:     企业库所有uscc列表
 * 备注:     导出和列表共用一份配置
 */
export const enterpriseUsccListConfig = {
    uscc:{key:"统一社会信用代码"},
    name:{key:"企业名称"}
};


/**
 * 使用端:   管理后台
 * 场景:     经营数据列表
 * 备注:     导出和列表共用一份配置
 */
export const manageListConfig = {
    id:{key:"标识"},
    uscc:{key:"统一信用代码"},
    name:{key:"企业名称"},
    year:{key:"数据年度"},
    period:{key:"数据时间"},
    BI:{key:"营业收入(万元)"},
    VAT:{key:"企业增值税(万元)"},
    CIT:{key:"企业所得税(万元)"},
    PIT:{key:"个人所得税(万元)"},
    RD:{key:"研发投入(万元)"},
};


/**
 * 使用端:   管理后台
 * 场景:     企业服务追踪列表
 * 备注:     导出和列表共用一份配置
 */
export const trackListConfig = {
    id:{key:"标识"},
    uscc:{key:"统一信用代码"},
    name:{key:"企业名称"},
    demand:{key:"需求类型"},
    content:{key:"需求描述详情"},
    contact:{key:"企业联系人"},
    contactUs:{key:"企业联系方式"},
    createTime:{key:"创建时间", changeDate:true},
    trackType:{key:"需求跟进状态"},
    followUpName:{key:"跟进人"},
    followUpTime:{key:"跟进时间"},
    followUpDsc:{key:"跟进详情"},
};


/**
 * 使用端:   管理后台
 * 场景:     园区活动列表
 * 备注:     导出和列表共用一份配置
 */
export const activityListConfig = {
    id:{key:"标识"},
    title:{key:"活动标题"},
    state:{key:"活动状态"},
    startTime:{key:"活动开始时间", changeDate:true},
    endTime:{key:"活动结束时间", changeDate:true},
    target:{key:"活动类型"},
    location:{key:"活动地点"},
    desc:{key:"活动详情"},
};


/**
 * 使用端:   管理后台
 * 场景:     政策列表
 * 备注:     导出和列表共用一份配置
 */
export const policyListConfig = {
    id:{key:"标识"},
    title:{key:"政策名称"},
    policyType:{key:"政策类型"},
    startTime:{key:"政策开始时间", changeDate:true},
    endTime:{key:"政策结束时间", changeDate:true},
    source:{key:"来源，发布单位"},
    desc:{key:"政策详情"},
};



