/**
 * 事件标签枚举
 * 
 */
export enum LABELTYPE {
    基础标签 = 1,
    入驻年份 = 2,
    企业性质 = 3,
    所属物业 = 4,
    自定义标签 = 5,
}


/**
 * 企业系统标签
 */
export enum ENTERPRISESYSTEMLABEL {
    "100平方公里" = 1,
    "3.73平方公里" = 2,
    软件关联入驻企业 = 3,
    小台账企业 = 4,
    重点稳商企业 = 5,
    /**企业性质 */
    实体型 = 6,
    虚拟型 = 7,
    注册型 = 8,
    /**所属物业 */
    于田大厦 = 601,
    汽车创新港 = 602,
    汽车城大厦 = 603,
    嘉亭荟 = 604,
    智驾园 = 605,
    同济科技园 = 606,
    /**入驻年份 */
    "2023年" = 2023,
    "2024年" = 2024,
    "2025年" = 2025,
    "2026年" = 2026,
    // "2027年" = 2027,
    // "2028年" = 2028,
    // "2029年" = 2029,
    // "2030年" = 2030,
    // "暂无年份" = 2100,
}


/**
 * 除去基础标签的其他下拉筛选
 */
export enum REMOVEBASICLABEL {
    实体型 = 6,
    虚拟型 = 7,
    注册型 = 8,
    于田大厦 = 601,
    汽车创新港 = 602,
    汽车城大厦 = 603,
    嘉亭荟 = 604,
    智驾园 = 605,
    同济科技园 = 606,
    "2023年" = 2023,
    "2024年" = 2024,
    "2025年" = 2025,
    "2026年" = 2026,
}


/**
 * 基础标签
 */
export enum BASELABEL {
    "100平方公里" = 1,
    "3.73平方公里" = 2,
    软件关联入驻企业 = 3,
    小台账企业 = 4,
    重点稳商企业 = 5,
}


/**
 * 入驻年份
 */
export enum YEARLABEL {
    "2023年" = 2023,
    "2024年" = 2024,
    "2025年" = 2025,
    "2026年" = 2026,
}


/**
 * 企业性质
 */
export enum ENTERPRISENATURE {
    实体型 = 6,
    虚拟型 = 7,
    注册型 = 8,
}


/**
 * 所属物业
 */
export enum PROPERTY {
    于田大厦 = 601,
    汽车创新港 = 602,
    汽车城大厦 = 603,
    嘉亭荟 = 604,
    智驾园 = 605,
    同济科技园 = 606,
}


/**
 * 标签状态
 */
export enum LABELUPDATEROAD {
    生效 = 1,
    重新生效,
    失效,
}


/**
 * 标签对象
 */
 export enum LABELGOAL {
    企业 = 1,
}


/**
 * 兼容管委会中企业管理前俩选项并不是标签
 */
export enum GUANWEIHUIMANANGENTERPRISELABEL {
    新注册企业 = 'xzcqy',
    新迁入企业 = 'xqrqy',
}

/**
 * 标签事件
 */
export enum LABELEVENT {
    入孵 = 1,
    迁出,
    融资,
    资质更新,
    孵化类型更新
}





