/**
 * 总路由入口
 */

import * as publicRouters from './public';
import * as adminuserRouters from './adminuser';
import * as negotiationRouters from './negotiation';
import * as enterpriseRouters from './enterprise';
import * as manageRouters from './manage';
import * as trackRouters from './track';
import * as activityRouters from './activity';
import * as policyRouters from './policy';
import * as importDataRouters from './importData';


export function setRouter(httpServer){
    /**下拉框等公用 路由 */
    publicRouters.setRouter(httpServer);

    /**小程序端 入口路由 */
    // mobileClientEnterpriseRouters.setRouter(httpServer);
    
    /**管理后台端 入口路由 */
    importDataRouters.setRouter(httpServer); //导入
    adminuserRouters.setRouter(httpServer); //用户
    negotiationRouters.setRouter(httpServer); //在谈在跟
    enterpriseRouters.setRouter(httpServer); //企业库
    manageRouters.setRouter(httpServer); //经营数据
    trackRouters.setRouter(httpServer); //企业服务追踪
    activityRouters.setRouter(httpServer); //园区活动
    policyRouters.setRouter(httpServer); //政策
    
}