/**
 * 管理后台 - 政策
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as policyBiz from "../biz/policy";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/policy/list', checkAdminUserToken, asyncHandler(getPolicyList));
    httpServer.post('/admin/policy/add', checkAdminUserToken, asyncHandler(addPolicy));
    httpServer.post('/admin/policy/info', checkAdminUserToken, asyncHandler(getPolicyInfo));
    httpServer.post('/admin/policy/update', checkAdminUserToken, asyncHandler(updatePolicy));
    httpServer.post('/admin/policy/del', checkAdminUserToken, asyncHandler(delPolicy));
    httpServer.post('/admin/policy/output', checkAdminUserToken, asyncHandler(outPutPolicyList));
}


/**
 * 政策-列表
 * @param req 
 * @param res 
 */
async function getPolicyList(req, res) {
    let reqConf = {title:'String', startTime:'Number', endTime:'Number', policyType:'Number', page:'Number'};
    const NotMustHaveKeys = ['title', 'startTime', 'endTime', 'policyType'];
    let {title, startTime, endTime, policyType, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await policyBiz.policyList(title, startTime, endTime, policyType, page);
    res.success(result);
}


/**
 * 政策-新增
 * @param req 
 * @param res 
 */
async function addPolicy(req, res) {
    let reqConf = {param:"Object"};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await policyBiz.policyCreate(param);
    res.success(result);
}


/**
 * 政策-回显
 * @param req 
 * @param res 
 */
async function getPolicyInfo(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await policyBiz.policyInfo(id);
    res.success(result);
}


/**
 * 政策-修改
 * @param req 
 * @param res 
 */
async function updatePolicy(req, res) {
    let reqConf = {id:"String", param:"Object"};
    let { id, param } = eccReqParamater(reqConf, req.body);

    let result = await policyBiz.policyUpdate(id, param);
    res.success(result);
}


/**
 * 政策-删除
 * @param req 
 * @param res 
 */
async function delPolicy(req, res) {
    let reqConf = {id:"String"};
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await policyBiz.policyDelete(id);
    res.success(result);
}


/**
 * 政策-导出
 * @param req 
 * @param res 
 */
 async function outPutPolicyList(req, res) {
    let reqConf = {title:'String', startTime:'Number', endTime:'Number', policyType:'Number'};
    const NotMustHaveKeys = ['title', 'startTime', 'endTime', 'policyType'];
    let {title, startTime, endTime, policyType} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await policyBiz.outPutPolicyData(title, startTime, endTime, policyType);
    res.success(result);
}





