/**
 * 管理后台 - 基础企业库
 */

import asyncHandler = require('express-async-handler');
import { eccReqParamater } from "../util/verificationParam";
import * as enterpriseBiz from "../biz/enterprise";
import { checkAdminUserToken } from "../middleware/user";

export function setRouter(httpServer) {
    httpServer.post('/admin/enterprise/list', checkAdminUserToken, asyncHandler(getEnterpriseList));
    httpServer.post('/admin/enterprise/add', checkAdminUserToken, asyncHandler(addEnterprise));
    httpServer.post('/admin/enterprise/info', checkAdminUserToken, asyncHandler(getEnterpriseInfo));
    httpServer.post('/admin/enterprise/update', checkAdminUserToken, asyncHandler(updateEnterprise));
    httpServer.post('/admin/enterprise/del', checkAdminUserToken, asyncHandler(delEnterprise));
    httpServer.post('/admin/enterprise/output', checkAdminUserToken, asyncHandler(outPutEnterprise));
}


/**
 * 基础企业库-列表
 * @param req 
 * @param res 
 */
async function getEnterpriseList(req, res) {
    let reqConf = {dataType:'Number', name:'String', industry:'[Number]', parkEntryTime:'Number', logonTime:'Number', labelIdList:'[String]', page:'Number'};
    const NotMustHaveKeys = ['dataType', 'name', 'industry', 'parkEntryTime', 'logonTime', 'labelIdList'];
    let {dataType, name, industry, parkEntryTime, logonTime, labelIdList, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseBiz.enterpriseList(dataType, name, industry, parkEntryTime, logonTime, labelIdList, page);
    res.success(result);
}


/**
 * 基础企业库-新增
 * @param req 
 * @param res 
 */
async function addEnterprise(req, res) {
    let reqConf = {param:"Object"};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.enterpriseCreate(param);
    res.success(result);
}


/**
 * 基础企业库-回显
 * @param req 
 * @param res 
 */
async function getEnterpriseInfo(req, res) {
    let reqConf = {uscc:"String"};
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.enterpriseInfo(uscc);
    res.success(result);
}


/**
 * 基础企业库-修改
 * @param req 
 * @param res 
 */
async function updateEnterprise(req, res) {
    let reqConf = {uscc:"String", param:"Object"};
    let { uscc, param } = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.enterpriseUpdate(uscc, param);
    res.success(result);
}


/**
 * 基础企业库-删除
 * @param req 
 * @param res 
 */
async function delEnterprise(req, res) {
    let reqConf = {uscc:"String"};
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.enterpriseDelete(uscc);
    res.success(result);
}


/**
 * 基础企业库-导出
 * @param req 
 * @param res 
 */
async function outPutEnterprise(req, res) {
    let reqConf = {name:'String', industry:'[Number]', parkEntryTime:'Number', logonTime:'Number', labelIdList:'[String]', dataType:'Number'};
    const NotMustHaveKeys = ['name', 'industry', 'parkEntryTime', 'logonTime', 'labelIdList', 'dataType'];
    let {name, industry, parkEntryTime, logonTime, labelIdList, dataType} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseBiz.outPutEnterpriseData(name, industry, parkEntryTime, logonTime, labelIdList, dataType);
    res.success(result);
}





 

