/**
 * 企业需求
 */


import {Schema} from 'mongoose';
import { sasp } from '../db/mongo/dbInit';


/**
 * 需求跟踪详情
 */
 const trackDetailsSchema = new Schema({
    tdid:String, //标识
    followUpName:String, //跟进人
    followUpTime:Number, //跟进时间
    followUpDsc:String, //跟进详情
    followUpStatus:Number, //跟进状态  未解决、已解决
})


/**
 * 企业需求
 */
const trackSchema = new Schema({
    id:{type:String, index:true}, //标识
    uscc:{type:String, index:true}, //企业uscc
    name:String, //企业名称
    demand:Number, //需求类型 VISITDEMAND
    content:String, //需求描述详情
    contact:String, //企业联系人
    contactUs:String, //企业联系方式
    trackType:Number, //需求跟进状态 
    createTime:Number, //创建时间
    details:{type:[trackDetailsSchema], default:[]}, //需求跟踪详情
});


var trackModel;
export function initModel(){
    trackModel = sasp.model('track', trackSchema);
    trackModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await trackModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 分页获取所有服务追踪
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 在跟在谈企业列表
 */
 export async function findTrackListToPage(selectParam, skipCount) {
    return await trackModel.find(selectParam).skip(skipCount).limit(10);
}


/**
 * 获取符合条件的服务追踪数量
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
export async function findTrackCount(selectParam) {
    return await trackModel.find(selectParam).countDocuments();
}


/**
 * 获取符合条件的服务追踪
 * @param selectParam 
 */
export async function findTrackByParam(selectParam) {
    return await trackModel.selectOnceData(selectParam);
}


/**
 * 获取符合条件的服务追踪列表
 * @param selectParam 
 */
export async function findTrackListByParam(selectParam) {
    return await trackModel.find(selectParam);
}


/**
 * 通过企业统一信用代码获取服务追踪
 * @param uscc 企业统一信用代码
 * @returns {}
 */
export async function findTrackByUscc(uscc:string) {
    return await trackModel.selectOnceData({uscc});
}


/**
 * 新增服务追踪
 * @param param 
 * @returns 
 */
export async function createDataByParam(param) {
    return await trackModel.create(param);
}


/**
 * 删除服务追踪
 * @param id 
 * @returns 
 */
export async function removeOneData(id:string) {
    return await trackModel.deleteOne({id});
}










