/**
 * 在谈在跟
 */

import {Schema} from 'mongoose';
import {sasp} from '../db/mongo/dbInit';

const negotiationSchema = new Schema({
    id:{type:String, index:true}, //标识
    // uscc:{type:String, index:true}, //统一信用代码
    name:{type:String, index:true}, //企业名称
    industry: [Number], //行业领域 ALLINDUSTRY
    registrationStatus:{type:Number, default:1}, //推进、注册情况 REGISTRATIONSTATUS: 1-洽谈中, 2-已注册, 3-已入驻, 4-已终止
    progressStatus:{type:Number, default:1}, //进展情况 PROGRESSSTATUS：1-初次接触, 2-深度洽谈, 3-协议草拟, 4-协议签订, 5-项目落地
    primaryContact:String, //负责人、首谈人
    contactDepartment:String, //对接部门
    createTime:Number, //创建时间
})


var negotiationModel;
export function initModel(){
    negotiationModel = sasp.model('negotiation', negotiationSchema);
    negotiationModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await negotiationModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 分页获取所有在谈在跟企业
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 在跟在谈企业列表
 */
export async function findNegotiationListToPage(selectParam, skipCount) {
    return await negotiationModel.find(selectParam).skip(skipCount).limit(10);
}


/**
 * 获取符合条件的企业数量
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
export async function findNegotiationCount(selectParam) {
    return await negotiationModel.find(selectParam).countDocuments();
}


/**
 * 获取符合条件的企业
 * @param selectParam 
 */
export async function findNegotiationByParam(selectParam) {
    return await negotiationModel.selectOnceData(selectParam);
}


/**
 * 获取符合条件的企业列表
 * @param selectParam 
 */
export async function findNegotiationListByParam(selectParam) {
    return await negotiationModel.find(selectParam);
}



/**
 * 通过企业统一信用代码获取企业信息
 * @param uscc 企业统一信用代码
 * @returns {}
 */
export async function findNegotiationByUscc(uscc:string) {
    return await negotiationModel.selectOnceData({uscc});
}


/**
 * 新增在谈在跟企业
 * @param param 
 * @returns 
 */
export async function createDataByParam(param) {
    return await negotiationModel.create(param);
}


/**
 * 删除在谈在跟企业
 * @param id 
 * @returns 
 */
export async function removeOneData(id:string) {
    return await negotiationModel.deleteOne({id});
}




