/**
 * 企业经营数据
 */

import {Schema} from 'mongoose';
import { sasp } from '../db/mongo/dbInit';

const manageSchema = new Schema({
    id:{type:String, index:true}, //标识
    uscc:{type:String, index:true}, //统一信用代码
    name:{type:String, index:true}, //企业名称
    year:{type:Number, index:true}, //数据年度
    period:{type:Number, index:true}, //数据时间 PERIOD：上半年(1-6月)、下半年(7-12月)、全年
    BI:{type:Number, default:0}, //营业收入(万元)
    VAT:{type:Number, default:0}, //企业增值税(万元)
    CIT:{type:Number, default:0}, //企业所得税(万元)
    PIT:{type:Number, default:0}, //个人所得税(万元)
    RD:{type:Number, default:0}, //研发投入(万元)
    isUpdate:{type:Boolean, default:false}, //是否修改
    isSubmit:{type:Boolean, default:false}, //是否提交
    createTime:Number, //提交时间
})


var manageModel;
export function initModel(){
    manageModel = sasp.model('manage', manageSchema);
    manageModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await manageModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 分页获取所有经营数据
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 经营数据列表
 */
export async function findManageListToPage(selectParam, skipCount) {
    return await manageModel.find(selectParam).skip(skipCount).limit(10);
}


/**
 * 获取符合条件的经营数据数量
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
export async function findManageCount(selectParam) {
    return await manageModel.find(selectParam).countDocuments();
}


/**
 * 获取符合条件的经营数据
 * @param selectParam 
 */
export async function findManageByParam(selectParam) {
    return await manageModel.selectOnceData(selectParam);
}


/**
 * 获取符合条件的经营数据列表
 * @param selectParam 
 */
export async function findManageListByParam(selectParam) {
    return await manageModel.find(selectParam);
}


/**
 * 通过企业统一信用代码获取经营数据
 * @param uscc 企业统一信用代码
 * @returns {}
 */
export async function findManageByUscc(uscc:string) {
    return await manageModel.selectOnceData({uscc});
}


/**
 * 新增经营数据
 * @param param 
 * @returns 
 */
export async function createDataByParam(param) {
    return await manageModel.create(param);
}


/**
 * 删除经营数据
 * @param id 
 * @returns 
 */
export async function removeOneData(id:string) {
    return await manageModel.deleteOne({id});
}


















