/**
 * 企业库
 */

import {Schema} from 'mongoose';
import { sasp } from '../db/mongo/dbInit';


/**
 * 创始团队
 */
 const initialTeamSchema = new Schema({
    type:Number,//创始团队人才类型
    memberName:String,//成员姓名
    memberSex:Number,//成员性别
    memberAge:Number,//成员年龄  出生年月时间戳
    memberDEGREE:Number,//成员最高学历
    memberSchool:String,//毕业学校
    des:String,//履历描述
},{_id:false});

/**企业资质 */
const qualificationSchema = new Schema({
    isHighTech:Boolean,
    highTechMs:Number,//高新技术
    isZjtx:Boolean,
    zjtxMs:Number,//专精特新
    isXjrpy:Boolean,
    xjrpyMs:Number,//小巨人培育
    isXjr:Boolean,
    xjrMs:Number,//小巨人
    beOnTheMarket:[Number],//上市情况
    isBeOnTheMarket:{type:Boolean, default:false}//是否上市
}, {_id:false});

/**专利 */
const intellectualPropertySchema = new Schema({
    alienPatent:Number,//海外专利
    classIPatent:Number,//一类专利
    secondClassPatent:Number,//二类专利
}, {_id:false});

/**租赁合同 */
const leaseScheme = new Schema({
    contractStartTime:Number,//合同开始时间
    contractEndTime:Number,//合同结束时间
    rentStartTime:Number,//租金开始时间
    rentEndTime:Number,//租金结束时间
})

//科创分
const kcfScheme = new Schema({
    industry:String,//
    subIndustry:String,//
    industryRanking:String,//
    score:String,//
}) 

/**股权结构 */
const guQuanJieGouItemScheme = new Schema({
    name:String,//名称
    finalBenefitPercent:String,//最终受益股份
    stockPercent:String,//持股比例
    stockType:String,//投资人类型
    realCapi:String,//实缴出资额
    paidUpCapitalUnit:String,//实缴出资额单位
    subscribedCapital:String,//认缴出资额数额
    subscribedCapitalUnit:String//认缴出资额单位
})

/**标签 */
const enterpriseLabelSchema = new Schema({
    labelId:String,
    labelType:Number, //标签类型 ENTERPRISESYSTEMLABEL
    state:{type:Boolean, default:true},//状态 false表示标签失效
},{_id:false});

/**企业库 */
const enterpriseSchema = new Schema({
    name: {type:String, index: true}, //企业名称
    uscc:{type:String, index: true}, //统一信用代码
    isSettled: Number, //是否入驻
    industry:[Number], //行业领域 INDUSTRY
    logonAddress:{type:[String], default:[]},//注册地址
    logonTime:Number, //注册时间、成立时间
    parkEntryTime: Number, //入驻园区时间
    leasedArea: Number, //租赁面积（㎡）
    enterpriseNature: Number, //企业性质 ENTERPRISENATURE：虚拟型、实体型、注册型
    property: Number, //所属物业 PROPERTY：于田大厦、同济科技园、汽车创新港......
    isInPut:{type:Boolean, default:false}, //是否是初始数据
    createTime:Number, //创建时间
    qualification:{type:qualificationSchema},//企业资质
    leaseInfo:{type:leaseScheme, default:{}},//租赁信息
    intellectualProperty:{type:intellectualPropertySchema},//知识产权
    initialTeam:{type:[initialTeamSchema], default:[]},//创始团队
    labels:{type:[enterpriseLabelSchema], default:[]},//标签系统

    /** 用户相关 */
    pwd:String,//登录密码
    token:{type:String, index:true},
    tokenMs:Number,
    firstLoginIsChangePwd:{type:Boolean, default:false},//首次登录是否修改密码

    /**导入的补充数据 */
    RAS:{type:Number}, //登记状态
    logOffMS:{type:Number}, //注销时间
    legalPerson:String, //法人
    zhuceziben:{type:String, default:'-'}, //注册资本
    shijiaoziben:{type:String, default:'-'}, //实缴资本
    dianHua:String, //电话
    gengDuoDianHua:{type:String}, //更多电话
    mail:{type:String, default:'-'}, //邮箱
    moreMail:{type:String, default:'-'}, //更多邮箱
    enterpriseType:{type:String, index:true}, //企业（机构）类型
    zhuCeHao:String, //注册号
    zuZhiJiGouDaiMa:String, //组织机构代码
    canBaoRenShu:Number, //参保人数
    canBaoRenShuNianBao:Number, //参保人数所属年报
    yingYeQiXian:String, //营业期限
    qiYeGuiMo:{type:Number, index:true}, //企业规模
    guanWang:String, //官网
    tongXinDiZhi:String, //通信地址
    jianJie:String, //企业简介
    dengJiJiGuan:String, //登记机关
    naShuiRenZiZhi:Number, //纳税人资质
    zuiXinNianBaoNianFen:Number, //最新年报年份
    jingYingFanWei:String, //经营范围
    industryCategoryGb: String, // 国标行业门类 INDUSTRY
    industryMajorGb: String, // 国标行业大类
    industryMediumGb: String, // 国标行业中类
    industryMinorGb: String, // 国标行业小类
    industryCategoryQcc: String, // 企查查行业门类
    industryMajorQcc: String, // 企查查行业大类
    industryMediumQcc: String, // 企查查行业中类
    industryMinorQcc: String, // 企查查行业小类
    guQuanJieGou:{type:[guQuanJieGouItemScheme], default:[]},//股权结构
    kcf:{type:kcfScheme, default:{}},//科创分
})


var enterpriseModel;
export function initModel(){
    enterpriseModel = sasp.model('enterprise', enterpriseSchema);
    enterpriseModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await enterpriseModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 分页获取所有企业
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 在跟在谈企业列表
 */
 export async function findEnterpriseListToPage(selectParam, skipCount) {
    return await enterpriseModel.find(selectParam).skip(skipCount).limit(10);
}


/**
 * 获取符合条件的企业数量
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
export async function findEnterpriseCount(selectParam) {
    return await enterpriseModel.find(selectParam).countDocuments();
}


/**
 * 通过企业统一信用代码获取企业信息
 * 支持.save方法保存对象修改
 * @param uscc 企业统一信用代码
 * @returns {}
 */
export async function findEnterpriseByUscc(uscc:string) {
    return await enterpriseModel.selectOnceData({uscc});
}


/**
 * 获取符合条件的企业列表
 * @param selectParam 
 */
export async function findEnterpriseListByParam(selectParam) {
    return await enterpriseModel.find(selectParam);
}


/**
 * 获取符合条件的单个企业
 * @param selectParam 
 */
export async function findEnterpriseByParam(selectParam) {
    return await enterpriseModel.selectOnceData(selectParam);
}


/**
 * 新增企业基础信息
 * @param param 
 * @returns 
 */
export async function createDataByParam(param) {
    return await enterpriseModel.create(param);
}


/**
 * 删除企业
 * @param uscc 
 * @returns 
 */
export async function removeOneData(uscc:string) {
    return await enterpriseModel.deleteOne({uscc});
}




