/**
 * 校验表单参数配置 【管理后台端】
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */

/**
 * 使用端:   管理后台
 * 场景:     新增管理员用户
 * 备注:     所有参数为必填
 */
export const AdminUserAddConfig = {
    loginId:{type:"String"}, //登录账号
    name:{type:"String"}, //名称
    pwd:{type:"String"}, //密码
};


/**
 * 使用端:   管理后台
 * 场景:     新增在谈在跟企业
 * 备注:     所有参数为必填
 */
export const NegotiationAddConfig = {
    name:{type:"String"}, //企业名称
    industry:{type:"[Number]"}, //行业领域
    registrationStatus:{type:"Number"}, //推进、注册情况
    progressStatus:{type:"Number"}, //进展情况
    primaryContact:{type:"String"}, //负责人、首谈人
    contactDepartment:{type:"String"}, //对接部门
};


/**
 * 使用端:   管理后台
 * 场景:     修改在谈在跟企业
 * 备注:     
 */
export const NegotiationUpdateConfig = {
    name:{type:"String"}, //企业名称
    industry:{type:"[Number]"}, //行业领域
    registrationStatus:{type:"Number"}, //推进、注册情况
    progressStatus:{type:"Number"}, //进展情况
    primaryContact:{type:"String"}, //负责人、首谈人
    contactDepartment:{type:"String"}, //对接部门
};


/**
 * 使用端:   管理后台
 * 场景:     新增企业建档
 * 备注:     所有参数为必填
 */
export const EnterpriseAddConfig = {
    name:{type:"String"}, //企业名称
    uscc:{type:"String"}, //统一信用代码
    logonAddress:{type:"[String]"}, //企业注册地址 ["所属省份", "所属城市", "所属区县", "详细地址"]
    logonTime:{type:"Number"}, //注册时间、成立时间
    parkEntryTime:{type:'Number'}, //入驻园区时间
    labels:{type:"[String]"}, //企业标签
    // industryCategoryGb:{type:"String"}, //国标行业门类
    industry:{type:"[Number]"}, //行业领域
    property:{type:"Number"}, //企业所属物业
    enterpriseNature:{type:"Number"}, //企业性质
    leasedArea:{type:"Number"}, //租赁面积（㎡）
    RAS:{type:"Number"}, //登记状态
    jingYingFanWei:{type:"String"}, //经营范围
    legalPerson:{type:"String"}, //法人
    zhuceziben:{type:"String"}, //注册资本
    dianHua:{type:"String"}, //电话
};


/**
 * 使用端:   管理后台
 * 场景:     修改企业建档
 * 备注:     所有参数为必填
 */
export const EnterpriseUpdateConfig = {
    name:{type:"String"}, //企业名称
    uscc:{type:"String"}, //统一信用代码
    logonAddress:{type:"[String]"}, //企业注册地址 ["所属省份", "所属城市", "所属区县", "详细地址"]
    logonTime:{type:"Number"}, //注册时间、成立时间
    parkEntryTime:{type:'Number'}, //入驻园区时间
    labels:{type:"[String]"}, //企业标签
    industry:{type:"[Number]"}, //行业领域
    property:{type:"Number"}, //企业所属物业
    enterpriseNature:{type:"Number"}, //企业性质
    leasedArea:{type:"Number"}, //租赁面积（㎡）
    RAS:{type:"Number"}, //登记状态
    jingYingFanWei:{type:"String"}, //经营范围
    legalPerson:{type:"String"}, //法人
    zhuceziben:{type:"String"}, //注册资本
    dianHua:{type:"String"}, //电话
};


/**
 * 使用端:   管理后台
 * 场景:     新增企业经营数据
 * 备注:     所有参数为必填
 */
export const ManageAddConfig = {
    uscc:{type:"String"}, //统一信用代码
    name:{type:"String"}, //企业名称
    year:{type:"Number"}, //数据年度
    period:{type:"Number"}, //数据时间 PERIOD 上半年(1-6月)、下半年(7-12月)、全年
    BI:{type:"Number"}, //营业收入(万元)
    VAT:{type:"Number"}, //企业增值税(万元)
    CIT:{type:"Number"}, //企业所得税(万元)
    PIT:{type:"Number"}, //个人所得税(万元)
    RD:{type:"Number"}, //研发投入(万元)
};


/**
 * 使用端:   管理后台
 * 场景:     修改企业经营数据
 * 备注:     
 */
export const ManageUpdateConfig = {
    uscc:{type:"String"}, //统一信用代码
    name:{type:"String"}, //企业名称
    year:{type:"Number"}, //数据年度
    period:{type:"Number"}, //数据时间 PERIOD 上半年(1-6月)、下半年(7-12月)、全年
    BI:{type:"Number"}, //营业收入(万元)
    VAT:{type:"Number"}, //企业增值税(万元)
    CIT:{type:"Number"}, //企业所得税(万元)
    PIT:{type:"Number"}, //个人所得税(万元)
    RD:{type:"Number"}, //研发投入(万元)
};


/**
 * 使用端:   管理后台
 * 场景:     新增企业服务追踪
 * 备注:     所有参数为必填
 */
export const TrackAddConfig = {
    uscc:{type:"String"}, //统一信用代码
    name:{type:"String"}, //企业名称
    demand:{type:"Number"}, //需求类型
    content:{type:"String"}, //需求描述
    contact:{type:"String"}, //企业联系人
    contactUs:{type:"String"}, //企业联系方式
    // trackType:{type:"Number"}, //需求跟进状态 同步详情记录的跟进状态
    createTime:{type:"Number"}, //创建服务追踪时间
    details:{type:"Array"}, //服务追踪记录
};


/**
 * 使用端:   管理后台
 * 场景:     新增企业服务追踪-详情记录
 * 备注:     所有参数为必填
 */
export const TrackDetailsAddConfig = {
    followUpName:{type:"String"}, //跟进人
    followUpTime:{type:"Number"}, //跟进时间
    followUpDsc:{type:"String"}, //跟进详情
    followUpStatus:{type:"Number"}, //跟进状态
};


/**
 * 使用端:   管理后台
 * 场景:     修改企业服务追踪
 * 备注:     
 */
export const TrackUpdateConfig = {
    uscc:{type:"String"}, //统一信用代码
    name:{type:"String"}, //企业名称
    demand:{type:"Number"}, //需求类型
    content:{type:"String"}, //需求描述
    contact:{type:"String"}, //企业联系人
    contactUs:{type:"String"}, //企业联系方式
    // trackType:{type:"Number"}, //需求跟进状态 同步详情记录的跟进状态
    createTime:{type:"Number"}, //创建服务追踪时间
    details:{type:"Array"}, //服务追踪记录
};


/**
 * 使用端:   管理后台
 * 场景:     修改企业服务追踪-详情记录
 * 备注:     所有参数为必填
 */
export const TrackDetailsUpdateConfig = {
    followUpName:{type:"String"}, //跟进人
    followUpTime:{type:"Number"}, //跟进时间
    followUpDsc:{type:"String"}, //跟进详情
    followUpStatus:{type:"Number"}, //跟进状态
};


/**
 * 使用端:   管理后台
 * 场景:     新增园区活动数据
 * 备注:     所有参数为必填
 */
export const ActivityAddConfig = {
    title:{type:"String"}, //活动标题
    state:{type:"Number"}, //活动状态
    startTime:{type:"Number"}, //活动开始时间
    endTime:{type:"Number"}, //活动结束时间
    target:{type:"[Number]"}, //活动类型
    location:{type:"String"}, //活动地点
    desc:{type:"String"}, //活动详情
};


/**
 * 使用端:   管理后台
 * 场景:     修改园区活动数据
 * 备注:     
 */
export const ActivityUpdateConfig = {
    title:{type:"String"}, //活动标题
    state:{type:"Number"}, //活动状态
    startTime:{type:"Number"}, //活动开始时间
    endTime:{type:"Number"}, //活动结束时间
    target:{type:"[Number]"}, //活动类型
    location:{type:"String"}, //活动地点
    desc:{type:"String"}, //活动详情  
};


/**
 * 使用端:   管理后台
 * 场景:     新增政策数据
 * 备注:     所有参数为必填
 */
export const PolicyAddConfig = {
    title:{type:"String"}, //政策名称
    policyType:{type:"Number"}, //政策类型
    startTime:{type:"Number"}, //政策开始时间
    endTime:{type:"Number"}, //政策结束时间
    source:{type:"String"}, //来源，发布单位
    desc:{type:"String"}, //政策详情
};


/**
 * 使用端:   管理后台
 * 场景:     修改政策数据
 * 备注:     
 */
export const PolicyUpdateConfig = {
    title:{type:"String"}, //政策名称
    policyType:{type:"Number"}, //政策类型
    startTime:{type:"Number"}, //政策开始时间
    endTime:{type:"Number"}, //政策结束时间
    source:{type:"String"}, //来源，发布单位
    desc:{type:"String"}, //政策详情
};







