/**
 * 标签下拉
 */
import * as labelData from "../data/label";

export async function getLabel(labelType?) {
    let selectParam:any = {};
    if (labelType) {
        selectParam.labelType = labelType;
    }

    /**需要用到的查询数据 */
    let labelDbList = await labelData.selectLabelList(selectParam);

    /**组合返回结果 */
    let dataList = [];
    labelDbList.forEach( info => {
        dataList.push({
            key: info.id,
            value: info.labelName
        })
    })

    return dataList;
}


/**
 * 不包含某标签类型的其他所有标签
 * @param labelType 
 * @returns 
 */
export async function getNotTypeLabel(labelType) {
    let selectParam:any = {};
    if (labelType) {
        selectParam.labelType = {"$nin": labelType};
    }

    /**需要用到的查询数据 */
    let labelDbList = await labelData.selectLabelList(selectParam);

    /**组合返回结果 */
    let dataList = [];
    labelDbList.forEach( info => {
        dataList.push({
            key: info.id,
            value: info.labelName
        })
    })

    return dataList;
}





