/**
 * 管理后台管理员用户
 */

import { AdminUserAddConfig } from "../config/eccParam/admin";
import { eccFormParam } from "../util/verificationParam";
import * as adminuserData from "../data/adminuser";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/errorEnum";
import { getPwdMd5, getToken } from "../tools/system";
import * as enterpriseData from "../data/enterprise";
import { ENTERPRISESYSTEMLABEL, PROPERTY } from "../config/enum/labelEnum";
import moment from "moment";
import { findTrackListByParam } from "../data/track";
import { TRACKTYPE } from "../config/enum";
import { changeEnumValue } from "../util/verificationEnum";
import * as labelEnum from "../config/enum/labelEnum";
let md5 = require("md5");



/**
 * 登录
 * @param loginId 登录账号 
 * @param pwd 密码
 */
export async function login(loginId:string, pwd:string) {
    let userInfo = await adminuserData.findAdminuserByLoginId(loginId);
    if (!userInfo || !userInfo.loginId) throw new BizError(ERRORENUM.未找到数据, `库中不存在loginId=${loginId}这个账号`);

    let checkPwd = getPwdMd5(loginId, md5(pwd));
    if (userInfo.pwd != checkPwd) throw new BizError(ERRORENUM.密码错误);

    let token = getToken(loginId);

    let resultUserInfo = {
        loginId: userInfo.loginId,
        name: userInfo.name,
        token,
    };

    userInfo.token = token;
    userInfo.tokenMs = new Date().valueOf();
    await userInfo.save();
    
    return resultUserInfo;
}


/**
 * 管理后台管理员用户-新增
 * @param uscc 
 * @param param 
 */
export async function adminUserCreate(param) {
    /**校验表单参数 */
    eccFormParam("管理后台新增管理员用户", AdminUserAddConfig, param);

    let adminuserDbInfo = await adminuserData.findAdminuserByParam({loginId:param.loginId});
    if (adminuserDbInfo && adminuserDbInfo.loginId)  throw new BizError(ERRORENUM.该账号已存在, `${param.loginId}已经在库中存在`);

    let pwd = getPwdMd5(param.loginId, md5(param.pwd));
    
    let adminuserInfo = {
        loginId: param.loginId,
        name: param.name,
        pwd,
    }

    await adminuserData.createAdminuserByParam(adminuserInfo);

    return {isSuccess:true};
}


/**
 * 数据看板
 */
// export async function homePage() {
//     let baseData = {
//         "企业总数":0,
//         "100平方公里范围企业":0,
//         "3.73平方公里实体租赁":0,
//         "关联入驻企业":0,
//         "小台账企业":0,
//         "重点稳商":0,
//         /**上月 */
//         "上月100平方公里范围企业":0,
//         "上月3.73平方公里实体租赁":0,
//         "上月关联入驻企业":0,
//         "上月小台账企业":0,
//         "上月重点稳商":0,
//     };

//     /** 查询企业数据 */
//     let enterpriseDbList = await enterpriseData.findEnterpriseListByParam({});
//     baseData.企业总数 = enterpriseDbList.length;
//     enterpriseDbList.forEach( info => {
//         let labels = info.labels;
//         labels.forEach( info => {
//             let {labelId, labelType, state} = info;
//             if (state) {
//                 if (labelId == ENTERPRISESYSTEMLABEL["100平方公里"]) baseData["100平方公里范围企业"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL["3.73平方公里"]) baseData["3.73平方公里实体租赁"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL.软件关联入驻企业) baseData["关联入驻企业"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL.小台账企业) baseData["小台账企业"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL.重点稳商企业) baseData["重点稳商"] += 1;
//             }
//         })
//     })

//     /**上月 */
//     /** 获取上月时间范围 */
//     let now = moment();
//     let lastMonthStart = moment().subtract(1, 'month').startOf('month').valueOf();
//     let lastMonthEnd = moment().subtract(1, 'month').endOf('month').valueOf();
//     /** 查询上月入驻的企业数据 */
//     let enterpriseLastMonthDbList = await enterpriseData.findEnterpriseListByParam({
//         parkEntryTime: {
//             $gte: lastMonthStart,
//             $lte: lastMonthEnd
//         }
//     });

//     // 统计上月数据
//     enterpriseLastMonthDbList.forEach(info => {
//         let labels = info.labels;
//         labels.forEach(label => {
//             let {labelId, labelType, state} = label;
//             if (state) {
//                 if (labelId == ENTERPRISESYSTEMLABEL["100平方公里"]) baseData["上月100平方公里范围企业"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL["3.73平方公里"]) baseData["上月3.73平方公里实体租赁"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL.软件关联入驻企业) baseData["上月关联入驻企业"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL.小台账企业) baseData["上月小台账企业"] += 1;
//                 if (labelId == ENTERPRISESYSTEMLABEL.重点稳商企业) baseData["上月重点稳商"] += 1;
//             }
//         });
//     });

//     return baseData;
// }


export async function homePage() {
    /**汇总数据 */
    let 汇总数据 = {
        "企业总数": 0,
        "100平方公里范围企业": 0,
        "3.73平方公里实体租赁": 0,
        "关联入驻企业": 0,
        "小台账企业": 0,
        "重点稳商": 0,
        /**较上月变化量 */
        "较上月100平方公里范围企业变化": 0,
        "较上月3.73平方公里实体租赁变化": 0,
        "较上月关联入驻企业变化": 0,
        "较上月小台账企业变化": 0,
        "较上月重点稳商变化": 0,
        "较上月总入驻企业变化": 0
    };

    /** 获取时间范围 */
    let lastMonthStart = moment().subtract(1, 'month').startOf('month').valueOf();
    let lastMonthEnd = moment().subtract(1, 'month').endOf('month').valueOf();
    
    /** 初始企业数据没有入驻时间处理：设置默认入驻时间：2025年12月 */
    let defaultParkEntryTime = moment('2025-12-01').startOf('month').valueOf();

    /** 查询所有企业数据 */
    let enterpriseDbList = await enterpriseData.findEnterpriseListByParam({});
    
    /** 统计当前所有企业数据 */
    汇总数据.企业总数 = enterpriseDbList.length;
    
    // 分别统计当前所有企业和上月企业
    let currentMonthStats = {
        "企业总数": 0,
        "100平方公里范围企业": 0,
        "3.73平方公里实体租赁": 0,
        "关联入驻企业": 0,
        "小台账企业": 0,
        "重点稳商": 0,
        "总入驻企业": 0
    };
    
    let lastMonthStats = {
        "企业总数": 0,
        "100平方公里范围企业": 0,
        "3.73平方公里实体租赁": 0,
        "关联入驻企业": 0,
        "小台账企业": 0,
        "重点稳商": 0,
        "总入驻企业": 0
    };

    // 遍历所有企业进行统计
    enterpriseDbList.forEach(info => {
        // 处理入驻时间：如果为空则使用默认时间
        let parkEntryTime = info.parkEntryTime || defaultParkEntryTime;
        
        // 统计当前所有企业的标签
        info.labels.forEach(label => {
            let {labelId, state} = label;
            if (state === false) return; //跳过失效标签
            
            switch(parseInt(labelId)) {
                case ENTERPRISESYSTEMLABEL["100平方公里"]:
                    currentMonthStats["100平方公里范围企业"] += 1;
                    break;
                case ENTERPRISESYSTEMLABEL["3.73平方公里"]:
                    currentMonthStats["3.73平方公里实体租赁"] += 1;
                    break;
                case ENTERPRISESYSTEMLABEL.软件关联入驻企业:
                    currentMonthStats["关联入驻企业"] += 1;
                    break;
                case ENTERPRISESYSTEMLABEL.小台账企业:
                    currentMonthStats["小台账企业"] += 1;
                    break;
                case ENTERPRISESYSTEMLABEL.重点稳商企业:
                    currentMonthStats["重点稳商"] += 1;
                    break;
            }
        });
        
        // 判断是否是上月入驻的企业
        if (parkEntryTime >= lastMonthStart && parkEntryTime <= lastMonthEnd) {
            lastMonthStats["总入驻企业"] += 1;
            
            // 统计上月企业的标签
            info.labels.forEach(label => {
                let {labelId, state} = label;
                if (!state) return;
                
                switch(parseInt(labelId)) {
                    case ENTERPRISESYSTEMLABEL["100平方公里"]:
                        lastMonthStats["100平方公里范围企业"] += 1;
                        break;
                    case ENTERPRISESYSTEMLABEL["3.73平方公里"]:
                        lastMonthStats["3.73平方公里实体租赁"] += 1;
                        break;
                    case ENTERPRISESYSTEMLABEL.软件关联入驻企业:
                        lastMonthStats["关联入驻企业"] += 1;
                        break;
                    case ENTERPRISESYSTEMLABEL.小台账企业:
                        lastMonthStats["小台账企业"] += 1;
                        break;
                    case ENTERPRISESYSTEMLABEL.重点稳商企业:
                        lastMonthStats["重点稳商"] += 1;
                        break;
                }
            });
        }
    });

    // 设置当前所有企业数量到汇总数据
    汇总数据["100平方公里范围企业"] = currentMonthStats["100平方公里范围企业"];
    汇总数据["3.73平方公里实体租赁"] = currentMonthStats["3.73平方公里实体租赁"];
    汇总数据["关联入驻企业"] = currentMonthStats["关联入驻企业"];
    汇总数据["小台账企业"] = currentMonthStats["小台账企业"];
    汇总数据["重点稳商"] = currentMonthStats["重点稳商"];

    // 计算变化量（本月数据 - 上月数据）
    汇总数据.较上月100平方公里范围企业变化 = currentMonthStats["100平方公里范围企业"] - lastMonthStats["100平方公里范围企业"];
    汇总数据["较上月3.73平方公里实体租赁变化"] = currentMonthStats["3.73平方公里实体租赁"] - lastMonthStats["3.73平方公里实体租赁"];
    汇总数据.较上月关联入驻企业变化 = currentMonthStats["关联入驻企业"] - lastMonthStats["关联入驻企业"];
    汇总数据.较上月小台账企业变化 = currentMonthStats["小台账企业"] - lastMonthStats["小台账企业"];
    汇总数据.较上月重点稳商变化 = currentMonthStats["重点稳商"] - lastMonthStats["重点稳商"];
    汇总数据.较上月总入驻企业变化 = currentMonthStats["总入驻企业"] - lastMonthStats["总入驻企业"];

    /**企业服务追踪 */
    let 企业服务追踪 = {
        企业需求总数:0,
        已解决企业需求:0,
        待解决需求数:0
    };
    /** 查询服务追踪数据 */
    let trackDbList = await findTrackListByParam({});
    企业服务追踪.企业需求总数 = trackDbList.length;
    trackDbList.forEach( info => {
        if (info.trackType == TRACKTYPE.已解决) 企业服务追踪.已解决企业需求 += 1;
        if (info.trackType == TRACKTYPE.未解决) 企业服务追踪.待解决需求数 += 1;
    })

    /**实体租赁企业场地分布 */
    let 实体租赁企业场地分布 = [];

    // 定义物业列表（按你的需求顺序）
    let propertyList = [
        { id: PROPERTY.于田大厦, name: "于田大厦" },
        { id: PROPERTY.汽车创新港, name: "汽车创新港" },
        { id: PROPERTY.汽车城大厦, name: "汽车城大厦" },
        { id: PROPERTY.嘉亭荟, name: "嘉亭荟" },
        { id: PROPERTY.智驾园, name: "智驾园" },
        { id: PROPERTY.同济科技园, name: "同济科技园" }
    ];

    // 初始化统计数组
    propertyList.forEach(property => {
        实体租赁企业场地分布.push({
            key: property.name,
            value: 0
        });
    });

    // 遍历所有企业，筛选实体型企业并按物业统计
    enterpriseDbList.forEach(info => {
        // 判断是否为实体型企业（ENTERPRISENATURE.实体型 = 6）
        if (info.enterpriseNature === 6) {
            let propertyValue = info.property;
            
            // 转换为数字类型以确保类型匹配
            let propertyValueNum = Number(propertyValue);
            
            // 找到对应的物业并计数
            let propertyIndex = propertyList.findIndex(p => p.id === propertyValueNum);
            if (propertyIndex !== -1) {
                实体租赁企业场地分布[propertyIndex].value += 1;
            }
        }
    });

    return {汇总数据, 企业服务追踪, 实体租赁企业场地分布};
}






