/**
 * 公共资源路由
 */
import asyncHandler = require('express-async-handler');
import * as labelConfig from '../config/enum/labelEnum';
import * as industryConfig from '../config/enum/industryEnum';
import * as enumConfig from '../config/enum';
import * as labelBiz from '../biz/labelValue';
import * as enterpriseBiz from "../biz/enterprise";
import { eccReqParamater } from '../util/verificationParam';

const config = {
    "/public/upexcel":enumConfig.UpExcelNameType, //导入相关
    "/public/label/labeltype":labelConfig.LABELTYPE, //标签类型
    "/public/industrycategorygb":industryConfig.INDUSTRY, //国标行业门类
    "/public/industry":industryConfig.ALLINDUSTRY, //行业领域
    "/public/ras":enumConfig.RAS, //登记状态
    "/public/registrationstatus":enumConfig.REGISTRATIONSTATUS, //推荐/注册情况
    "/public/progressstatus":enumConfig.PROGRESSSTATUS, //进展情况
    "/public/period":enumConfig.PERIOD, //数据时间 上半年(1-6月)、下半年(7-12月)、全年
    "/public/demand":enumConfig.VISITDEMAND, //需求类型
    "/public/tracktype":enumConfig.TRACKTYPE, //需求跟进状态
    "/public/activitystate":enumConfig.ACTIVITYSTATE, //活动状态
    "/public/activitytarget":enumConfig.ACTIVITYTARGET, //活动类型
    "/public/policytype":enumConfig.POLICYTYPE, //政策类型
}

export function setRouter(httpServer) {
    for (let modelKey in config) {
        httpServer.post(modelKey, asyncHandler(getEnum(config[modelKey])));
    }

    httpServer.post('/public/enterprise/uscc', asyncHandler(getAllUscc));
    httpServer.post('/public/label/all', asyncHandler(getAllLabel));
    httpServer.post('/public/label/base', asyncHandler(getBaseLabel));
    httpServer.post('/public/label/property', asyncHandler(getPropertyLabel));
    httpServer.post('/public/label/enterprisenature', asyncHandler(getEnterpriseNatureLabel));
    httpServer.post('/public/label/year', asyncHandler(getYearLabel));
    httpServer.post("/public/label/nottype", asyncHandler(getNotTypeLabel));
}


/**
 * 获取所有企业uscc
 * @param req 
 * @param res 
 */
async function getAllUscc(req, res) {
    let result = await enterpriseBiz.enterpriseUsccList();
    res.success(result);
}


/**
 * 获取所有标签下拉
 * @param req 
 * @param res 
 */
 async function getAllLabel(req, res) {
    let result = await labelBiz.getLabel();
    res.success(result);
}


/**
 * 获取基础标签下拉
 * @param req 
 * @param res 
 */
async function getBaseLabel(req, res) {
    let result = await labelBiz.getLabel(labelConfig.LABELTYPE.基础标签);
    res.success(result);
}


/**
 * 获取所属物业标签下拉
 * @param req 
 * @param res 
 */
async function getPropertyLabel(req, res) {
    let result = await labelBiz.getLabel(labelConfig.LABELTYPE.所属物业);
    res.success(result);
}


/**
 * 获取企业性质标签下拉
 * @param req 
 * @param res 
 */
async function getEnterpriseNatureLabel(req, res) {
    let result = await labelBiz.getLabel(labelConfig.LABELTYPE.企业性质);
    res.success(result);
}


/**
 * 获取入驻年份标签下拉
 * @param req 
 * @param res 
 */
async function getYearLabel(req, res) {
    let result = await labelBiz.getLabel(labelConfig.LABELTYPE.入驻年份);
    res.success(result);
}



async function getNotTypeLabel(req, res) {
    let reqConf = {labelType:"Number"};
    let { labelType } = eccReqParamater(reqConf, req.body);
    
    let result = await labelBiz.getNotTypeLabel(labelType);
    res.success(result);
}


/**
 * 获取枚举
 * @param enumCof 
 * @returns 
 */
function getEnum(enumCof) {
    return async function (req, res) {
        let dataList = [];
        for (let key in enumCof) {
            let anyKey:any = key;
            if (isNaN(anyKey)) {
                dataList.push({key, value:enumCof[key]});
            }
        }
        res.success({dataList});
    }
}

