/**
 * 政策
 */

import {Schema} from 'mongoose';
import { sasp } from '../db/mongo/dbInit';


const policySchema = new Schema({
    id:{type:String, index:true},//标识
    title:String,//政策名称
    policyType:Number, //政策类型 1=财政补贴 2=资质申报 3=政策扶持
    startTime:Number, //政策开始时间
    endTime:Number, //政策结束时间
    source:String, //来源，发布单位
    desc:String, //政策详情
    createTime:Number, //创建时间
})


var policyModel;
export function initModel(){
    policyModel = sasp.model('policy', policySchema);
    policyModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await policyModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 分页获取所有政策
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 政策列表
 */
export async function findPolicyListToPage(selectParam, skipCount) {
    return await policyModel.find(selectParam).skip(skipCount).limit(10);
}


/**
 * 分页获取所有政策-排序
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 政策列表
 */
 export async function findPolicyListToPageSort(selectParam, skipCount, sortParam) {
    return await policyModel.find(selectParam).sort(sortParam).skip(skipCount).limit(10);
}


/**
 * 获取符合条件的政策数量
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
export async function findPolicyCount(selectParam) {
    return await policyModel.find(selectParam).countDocuments();
}


/**
 * 获取符合条件的政策
 * @param selectParam 
 */
export async function findPolicyByParam(selectParam) {
    return await policyModel.selectOnceData(selectParam);
}


/**
 * 获取符合条件的政策
 * @param selectParam 
 */
export async function findPolicyByParamSort(selectParam, sortParam) {
    return await policyModel.find(selectParam).sort(sortParam);
}


/**
 * 获取符合条件的政策列表
 * @param selectParam 
 */
export async function findPolicyListByParam(selectParam) {
    return await policyModel.find(selectParam);
}


/**
 * 新增政策
 * @param param 
 * @returns 
 */
export async function createDataByParam(param) {
    return await policyModel.create(param);
}


/**
 * 删除政策
 * @param id 
 * @returns 
 */
export async function removeOneData(id:string) {
    return await policyModel.deleteOne({id});
}






