
export enum ERRORENUM {
    未找到数据,
    参数错误,
    不能重复提交任务,
    请完善信息,
    该企业已存在,
    数据无更新,
    密码错误,
    密码不允许有特殊字符,
    不能重复修改密码,
    身份验证失败,
    非法登录,
    身份验证过期,
    密码长度不能超过24个字符,
    账号不存在,
    已入库的数据不能删除,
    任务不存在,
    该企业不存在,
    密码不一致,
    密码只能由6至18位字符和数字组成,
    统一社会信用代码不合法,
    统一社会信用代码重复,
    系统错误,
    该任务已提交,
    无法操作其他孵化器的企业,
    请填入其他原因,
    账号非绑定关系,
    code无效,
    频繁操作请稍后再试,
    高风险等级用户,
    系统繁忙,
    绑定失败,
    发送验证码次数超限制,
    发送验证码频率过快,
    没有联系人,
    号码与主体不一致,
    验证码错误,
    验证码失效,
    验证码过期,
    不能修改过期任务数据,
    短信发送失败,
    地址数据不完整,
    字数超过200限制,
    只能修改本企业信息,
    请勿重复提交填报数据,
    只能删除本企业信息,
    不能补录已有数据,
    请正确填报数据,
    不能重复创建填报,
    请先创建填报数据,
    重复通过填报数据,
    请先选择是否拥有,
    请先关闭该资讯,
    请不要重复开启资讯,
    未填报数据不能删除,
    已提交的数据不能进行操作,
    请先填报数据,
    只能上传png或jpg图片,
    文件上传失败,
    系统错误请联系管理员,
    缺少关键参数导致修改失败,
    不合规操作,
    未填安全手机号无法修改密码,
    请输入聊天内容,
    目标数据不存在,
    不能删除非自定义标签,
    该数据周期已存在此类型任务,
    任务延期不可将开始时间提前,
    任务延期结束时间要大于开始时间,
    不可提前回收已完成任务,
    缺少月份参数,
    多余年份与月份参数,
    不可以创建未来数据月的任务, 
    填报周期不能小于数据周期,
    不可选择未来时间,
    手机号不存在,
    只能上传doc或docx或png或jpg图片,
    空文件失败,
    上传时缺失关键参数,
    该账号已存在,
    该标签不存在,
    该活动已存在,
    该政策已存在,
    企业性质不可多选,
    所属物业不可多选,
    入驻年份不可多选
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403,
    code无效 = 40029,
    频繁操作请稍后再试 = 45011,
    高风险等级用户 = 40226,
    系统繁忙 = 40227
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}