import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "../util/bizError";
import { TYPEENUM } from "../config/enum";

/**
 * 根据conf配置校验请求参数
 * @param conf 配置  
 * @param param 表单  
 * @param skipKeys []不必填的字段
 */
export function eccReqParamater(conf:object, param, skipKeys?) {
    skipKeys = skipKeys || [];

    let skipMap = {};
    skipKeys.forEach(keyName => {
        skipMap[keyName] = 1;
    });

    /**校验多余字段 */
    for (let key in param) {
        if (!conf[key]) throw new BizError(ERRORENUM.参数错误, `多余${key}字段`);
    }

    /**校验必填和缺失字段 */
    for (let key in conf) {
        let confType = conf[key];
        let value = param[key];
        let valueType = typeof value;
        
        if ( value == null || value == undefined ) {
            if (!skipMap[key]) throw new BizError(ERRORENUM.参数错误, `缺失${key}字段`);
        } else {
            let isError = false;
            let errorStr = "";
            switch(confType) {
                case 'Number':
                    if ( confType.toLowerCase() != valueType ) isError = true;
                    else {
                        if ((""+param[key]).indexOf('.') > -1) {
                            param[key] = parseInt(`${param[key] *100}`)/100;
                        }
                    }
                break;
                case 'String':
                case 'Boolean':
                case 'Object':
                    if ( confType.toLowerCase() != valueType ) isError = true;
                break;
                case '[Number]':
                    if ( !Array.isArray(param[key]) ) isError = true;
                    for (let i =0; i <  param[key].length; i++) {
                        let item = param[key][i];
                        if ( typeof item != 'number' ) {
                            isError = true;
                            errorStr = `${key}应是number型数组其中下标${i}是${typeof item}`;
                        }
                    }
                break;
                case '[Object]':
                    if ( !Array.isArray(param[key]) ) isError = true;
                    for (let i =0; i <  param[key].length; i++) {
                        let item = param[key][i];
                        if ( typeof item != 'object' ) {
                            isError = true;
                            errorStr = `${key}应是object型数组其中下标${i}是${typeof item}`;
                        }
                    }
                break;
                case '[String]':
                    if ( !Array.isArray(param[key]) ) isError = true;
                    for (let i =0; i <  param[key].length; i++) {
                        let item = param[key][i];
                        if ( typeof item != 'string' ) {
                            isError = true;
                            errorStr = `${key}应是String型数组其中下标${i}是${typeof item}`;
                        }
                    }
                break;
                // case 'Address':
                //     /**地址类型 基本数据类型为数组字符串但是要判断层级关系 */
                //     if ( !Array.isArray(param[key]) ) {
                //         isError = true;
                //         errorStr = `${key}应是数组形`;
                //     }
                //     if ( param[key].length != 4) {
                //         isError = true;
                //         errorStr = `${key}超过特定长度4 目前长度 ${param[key].length}`;
                //     }
                //     for (let i =0; i <  param[key].length; i++) {
                //         let item = param[key][i];
                //         if ( typeof item != 'string' ) {
                //             isError = true;
                //             errorStr = `${key}应是string型数组其中下标${i}是${typeof item}`;
                //         }
                //     }
                //     /** 不符合规则的 */
                //     let nullIndex = -1;
                //     for (let i = 0; i < param[key].length; i++) {
                //         if (nullIndex != -1) {//出现过空 第一次出现后的位置 都不能有值
                //             if (param[key]) {
                //                 //做一个特化
                //                 throw new BizError(ERRORENUM.地址数据不完整, `${key} 下标 ${nullIndex} 为空 `);
                //             }
                //         }
                //         if (nullIndex == -1 && !param[key][i]) {
                //             /**按顺序第一次赋值 */
                //             nullIndex = i;
                //         }
                //     }
    
                // break;
            }
            errorStr = isError && errorStr == "" ? `${key}应该是${confType}型 而不是${valueType}`: errorStr;
            if (isError) throw new BizError(ERRORENUM.参数错误, errorStr);
        }

    }

    return param;
}


//对象判空
export function objectKeyIsNull(obj, ...keyNames) {
    let isNull = false;
    for (let i = 0; i < keyNames.length; i++) {
        let keyStr = keyNames[i];
        let moreKeyList = keyStr.split(".");
        let lastObj;
        for (let j = 0; j < moreKeyList.length; j++) {
            lastObj = obj[moreKeyList[j]];
            if (!lastObj) {
                isNull = true;
                break;
            }
        }
        if (isNull) break;
    }
    return isNull;
}

/**
 * 校验类型
 * @param target 目标值
 * @param type TYPEENUM枚举值
 * @returns 通过 = true   不通过 = false
 */
export function checkType(target, type) {
    if (target == undefined || target == null) return false;
    switch (type) {
        case TYPEENUM.string:
            if (typeof target == 'string') {
                return true;
            }
        break;
        case TYPEENUM.number:
            if (typeof target == 'number') {
                return true;
            }
        break;
        case TYPEENUM.object:
            if (typeof target == 'object' && !Array.isArray(target) ) {
                return true;
            }
        break;
        case TYPEENUM.array:
            if (typeof target == 'object' && Array.isArray(target) ) {
                return true;
            }
        break;
        case TYPEENUM.boolean:
            if (typeof target == 'boolean') {
                return true;
            }
        break;
    };
    return false;
}

export function checkStrLeng(str, length?) {
    length = length ? length : 40;
    let result = true;
    if (str.length < length) result = false;
    return result;
}


