// test-xmlrpc.js

const xmlrpc = require('xmlrpc');

console.log('🧪 测试所有XML-RPC方法...');

const client = xmlrpc.createClient({
    host: '127.0.0.1',
    port: 13277, // HTTPS默认端口
    path: '/gzn/rpc',
    url: 'http://127.0.0.1:13277/gzn/rpc' // 明确指定完整URL
});

// 格式化日期为 YYYY-MM-DD HH:MM:SS 格式
function formatDate(date) {
    const d = new Date(date);
    const year = d.getFullYear();
    const month = String(d.getMonth() + 1).padStart(2, '0');
    const day = String(d.getDate()).padStart(2, '0');
    const hours = String(d.getHours()).padStart(2, '0');
    const minutes = String(d.getMinutes()).padStart(2, '0');
    const seconds = String(d.getSeconds()).padStart(2, '0');
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
}

// 测试数据 - 根据表结构调整字段值
const testUser = {
    user_id: 'test_user_005',
    group_id: 1,
    user_name: 'testuser',
    user_type: 'stu', // 修改为3个字符，符合 STRING(5) 限制
    active_flag: 1,
    admin_flag: 0,
    create_date: formatDate(new Date()), // 使用格式化后的日期
    name: '测试用户',
    verified_status: 0,
    is_sx: 0,
    order_id: 0,
    is_train: 0,
    zw_mark: 0,
    uoid: 0
};

const testUpdateUser = {
    user_id: 'test_user_003',
    group_id: 1,
    user_name: 'testuserupdate',
    user_type: 'stu', // 修改为3个字符，符合 STRING(5) 限制
    active_flag: 1,
    admin_flag: 0,
    create_date: formatDate(new Date()), // 使用格式化后的日期
    name: '测试用户',
    verified_status: 0,
    is_sx: 0,
    order_id: 0,
    is_train: 0,
    zw_mark: 0,
    uoid: 0
};

const testGroup = {
    group_id: 1001,
    group_name: '测试组',
    parent_id: 0,
    thread_id: 1,
    group_flag: 1
};

// 修改参数传递方式 - 将参数展开而不是作为数组
const testMethods = [
    {
        name: 'user.syncUser',
        params: testUser,
        description: '用户同步'
    },
    {
        name: 'user.addUser',
        params: testUser,
        description: '添加用户'
    },
    {
        name: 'user.updateUserCommon',
        params: testUpdateUser,
        description: '更新用户'
    },
    {
        name: 'user.deleteUser',
        params: "'test_user_001','test_user_002'",
        description: '删除用户'
    },
    {
        name: 'system.listMethods',
        params: null,
        description: '列出方法'
    }
];

// 顺序测试所有方法
let currentIndex = 0;

function testNextMethod() {
    if (currentIndex >= testMethods.length) {
        console.log('✅ 所有方法测试完成');
        return;
    }

    const method = testMethods[currentIndex];
    console.log(`\n${currentIndex + 1}. 测试 ${method.name} (${method.description})...`);
    console.log('📤 发送参数:', JSON.stringify(method.params, null, 2));

    // 根据参数类型决定如何调用
    if (method.params === null || method.params === undefined) {
        client.methodCall(method.name, [], (err, result) => {
            handleResponse(err, result, method);
        });
    } else if (Array.isArray(method.params)) {
        client.methodCall(method.name, method.params, (err, result) => {
            handleResponse(err, result, method);
        });
    } else {
        client.methodCall(method.name, [method.params], (err, result) => {
            handleResponse(err, result, method);
        });
    }
}

function handleResponse(err, result, method) {
    if (err) {
        console.error(`❌ ${method.name} 失败:`, err.message);
    } else {
        console.log(`✅ ${method.name} 成功:`, result);
    }

    currentIndex++;
    setTimeout(testNextMethod, 1000);
}

// 开始测试
testNextMethod();

// 超时处理
setTimeout(() => {
    console.log('\n⏰ 测试超时');
    process.exit(0);
}, 30000);