const path = require('path');
import * as fs from "fs";
import { BizError } from "../util/bizError";
import { analysisXml } from "../util/myXML";
import { ServerConfig } from "../config/systemClass";

export let systemConfig = new ServerConfig();

const ConfigName = "serverConfig.xml";

export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0, __dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo: any = await analysisXml(configStr);
        
        if (!configInfo || !configInfo.config) throw new BizError('xml中无配置');
        
        let { port, sign, dbServer, mysqldb, xmlRpcServer } = configInfo.config;
        
        // 基本配置
        systemConfig.port = parseInt(port[0]);
        systemConfig.sign = sign[0];
        systemConfig.dbPath = dbServer[0];
        
        // MySQL配置
        if (mysqldb) {
            let dbConfigInfo = mysqldb[0];
            systemConfig.mysqldb = { host: '', port: 0, user: '', pwd: '', dataBase: '' };
            
            if (dbConfigInfo.mysqlHost && dbConfigInfo.mysqlPort && dbConfigInfo.mysqlUser && dbConfigInfo.dataBase) {
                systemConfig.mysqldb.host = dbConfigInfo.mysqlHost[0];
                systemConfig.mysqldb.port = parseInt(dbConfigInfo.mysqlPort[0]);
                systemConfig.mysqldb.user = dbConfigInfo.mysqlUser[0];
                systemConfig.mysqldb.pwd = dbConfigInfo.mysqlPwd[0] || "";
                systemConfig.mysqldb.dataBase = dbConfigInfo.dataBase[0];
            }
        }
        
        // XML-RPC服务器配置
        if (xmlRpcServer) {
            let rpcConfig = xmlRpcServer[0];
            systemConfig.xmlRpcServer = {
                enabled: rpcConfig.enabled && rpcConfig.enabled[0] === 'true',
                port: rpcConfig.port ? parseInt(rpcConfig.port[0]) : 8000,
                host: rpcConfig.host ? rpcConfig.host[0] : 'localhost',
                path: rpcConfig.path ? rpcConfig.path[0] : '/rpc',
                auth: {
                    username: rpcConfig.auth && rpcConfig.auth[0].username ? rpcConfig.auth[0].username[0] : 'K12RPC',
                    password: rpcConfig.auth && rpcConfig.auth[0].password ? rpcConfig.auth[0].password[0] : 'K12RPC!Pwd1901'
                }
            };
        } else {
            // 默认配置
            systemConfig.xmlRpcServer = {
                enabled: false,
                port: 8000,
                host: 'localhost',
                path: '/rpc',
                auth: {
                    username: 'K12RPC',
                    password: 'K12RPC!Pwd1901'
                }
            };
        }
        
        console.log("config init success");
        console.log("XML-RPC配置:", systemConfig.xmlRpcServer);

    } catch(err) {
        console.log('ERROR => 服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确');
        console.log(err);
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}

function analysisMongoConnectStr(path, port, dataBase, w, timeOutMs) {
    return `mongodb://${path}:${port}/${dataBase}?w=${w}&wtimeoutMS=${timeOutMs}`;
}