import { table } from "console";
import { Association } from "sequelize";

const { Sequelize, DataTypes } = require('sequelize');

export const TablesConfig = [
    {
        tableNameCn:'维度表',
        tableName:'dimension',
        schema:{
            dimension_id: {
                type:Sequelize.STRING(50), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            dimension_name:{type:Sequelize.STRING(50)}, //维度名称（如家国情怀、国际视野）
            direction:{type:Sequelize.STRING(10)}, //所属大方向（公/智/能）
        },
        association: [
            {type:"hasMany", check:"question", foreignKey:"dimension_id"}
        ]
    },
    {
        tableNameCn:'题目表',
        tableName:'question',
        schema:{
            question_id: {
                type:Sequelize.STRING(50), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            dimension_id:{type:Sequelize.STRING(50), allowNull:false}, //关联维度表的维度ID
            question_content:{type:Sequelize.TEXT}, //题目具体描述
            question_order:{type:Sequelize.INTEGER(2)}, //题目在维度内的序号（1-4）
        },
        association: [
            {type:"hasMany", check:"answer_record_detail", foreignKey:"question_id"}
        ]
    },
    {
        tableNameCn:'答题记录表',
        tableName:'answer_record',
        schema:{
            record_id: {
                type:Sequelize.STRING(50),
                allowNull:false,
                primaryKey:true,
                unique:true
            },
            student_id:{type:Sequelize.STRING(50), allowNull:false}, // 关联学生id
            student_name:{type:Sequelize.STRING(50)}, // 学生名称
            total_score:{type:Sequelize.INTEGER}, // 总分
            answer_time:{type:Sequelize.DATE}, // 答题时间
            answer_status:{type:Sequelize.INTEGER}, // 答题状态：0未完成 1已完成
        },
        association: [
            {type:"hasMany", check:"answer_record_detail", foreignKey:"record_id"}
        ]
    },
    {
        tableNameCn:'答题记录明细表',
        tableName:'answer_record_detail',
        schema:{
            detail_id: {
                type:Sequelize.STRING(50),
                allowNull:false,
                primaryKey:true,
                unique:true
            },
            record_id:{type:Sequelize.STRING(50), allowNull:false}, // 关联答题记录表id
            question_id:{type:Sequelize.STRING(50), allowNull:false}, // 关联题目id
            score:{type:Sequelize.INTEGER}, // 题目得分（1-7分）
        },
        association: []
    },
    {
        tableNameCn:'狮子形象表',
        tableName:'nm_lion_image',
        schema:{
            lion_id: {
                type:Sequelize.STRING(50),
                allowNull:false,
                primaryKey:true,
                unique:true
            },
            standard_name:{type:Sequelize.STRING(255), allowNull:false}, // 狮子名称（标准名）
            alias_name:{type:Sequelize.STRING(255), allowNull:true}, // 狮子名称（别名）
            characteristic:{type:Sequelize.TEXT, allowNull:false}, // 特征描述
            judgment_condition:{type:Sequelize.STRING(255), allowNull:false}, // 判定条件
            magic_artifact:{type:Sequelize.STRING(255), allowNull:false}, // 法器（优势）名称
            magic_artifact_text:{type:Sequelize.TEXT, allowNull:false}, // 法器文字描述
            suggestion:{type:Sequelize.STRING(255), allowNull:false}, // 镜囊（建议）名称
            suggestion_text:{type:Sequelize.TEXT, allowNull:false}, // 镜囊文字描述
            lion_image:{type:Sequelize.STRING(255), allowNull:false}, // 狮子形象（图片地址）
        },
        association: []
    },
    {
        tableNameCn: 'UAC统一用户表',
        tableName: 'uac_user',
        schema: {
            user_id: {
                type: DataTypes.STRING(20), //登录用户名（主键）
                allowNull: false,
                primaryKey: true,
                unique:true
            },
            group_id: {type: DataTypes.INTEGER, allowNull: false}, //所属组ID
            user_name: {type: DataTypes.STRING(20), allowNull: false}, //真实姓名
            nickname: {type: DataTypes.STRING(20), allowNull: true}, //昵称
            gender: {type: DataTypes.STRING(10), allowNull: true}, //性别（男/女）
            email: {type: DataTypes.STRING(50), allowNull: true}, //电子邮件
            user_type: {type: DataTypes.STRING(5), allowNull: false}, //用户身份代码（5位，分别代表一般注册用户、行政管理人员、教职员工、学生、家长）
            active_flag: {type: DataTypes.INTEGER, allowNull: false, defaultValue: 2}, //用户状态标志（0-禁用，1-正常，2-未激活）
            admin_flag: {type: DataTypes.INTEGER, allowNull: false, defaultValue: 0}, //帐号标志（-1：公共帐号，0：一般成员，1：所属组组长，2：超级管理员）
            create_date: {type: DataTypes.STRING(19), allowNull: false}, //创建时间（格式：YYYY-MM-DD HH:MM:SS）
            extend_info: {type: DataTypes.STRING(250), allowNull: true}, //用户扩展信息（JSON格式）
            person_id: {type: DataTypes.STRING(15), allowNull: true}, //自然人ID（额外信息）
            id_type: {type: DataTypes.INTEGER, allowNull: true}, //证件类型（1-居民身份证，2-香港特区身份证明...）
            id_card: {type: DataTypes.STRING(30), allowNull: true}, //证件号码
            name: {type: DataTypes.STRING(50), allowNull: true}, //证件姓名
            verified_status: {type: DataTypes.INTEGER, allowNull: true, defaultValue: 0}, //实名认证状态（0-未认证，1-已认证，2-人工认证）
            phone: { type: DataTypes.STRING(11), allowNull: true}, //手机号
            birthday: {type: DataTypes.STRING(10), allowNull: true}, //生日（格式：YYYY-MM-DD）
            password: {type: DataTypes.STRING(20), allowNull: true}, //密码（额外信息）
            forbidden_reason: {type: DataTypes.INTEGER, allowNull: true}, //禁用状态标识（1-管理员禁用...7-毕业禁用）
            xhjw_user_id: {type: DataTypes.INTEGER, allowNull: true}, //教务系统用户ID
            is_sx: {type: DataTypes.INTEGER, allowNull: true, defaultValue: 0}, //师训标记（0-未关联，1-已关联）
            order_id: {type: DataTypes.INTEGER, allowNull: true, defaultValue: 0}, //排序号（数字越大越靠前）
            student_user_id: {type: DataTypes.STRING(20), allowNull: true}, //家长关联的学生帐号
            is_train: {type: DataTypes.INTEGER, allowNull: true, defaultValue: 0}, //是否参训人员（0-否，1-是）
            zw_mark: {type: DataTypes.INTEGER, allowNull: true, defaultValue: 0}, //政务标识（0-无，1-有，2-继承组）
            eduid: {type: DataTypes.STRING(40), allowNull: true}, //EduID
            uoid: {type: DataTypes.INTEGER, allowNull: true, defaultValue: 0}, //本组内排序号
            user_mark: {type: DataTypes.STRING(20), allowNull: true}, //用户标识（政务,院务,校务）
        },
        association: []
    },
    {
        tableNameCn:'管理后台用户',
        tableName:'adminUser',
        schema:{
            aId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            loginId:{type:Sequelize.STRING(255), allowNull:false}, //用户
            token:{type:Sequelize.STRING(255)}, //token
            tokenMs:{type:Sequelize.DATE}, //token的时间
            name:{type:Sequelize.STRING(255)},//用户名称
            permission:{type:Sequelize.INTEGER, allowNull: true, defaultValue: 0}, //本系统权限-是否管理员（0-否，1-是）
        },
        association: []
    },
    {
        tableNameCn:'服务开启时间',
        tableName:'opening_time',
        schema:{
            otId:{
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            startTime:{type:Sequelize.DATE}, //开始时间
            endTime:{type:Sequelize.DATE}, //结束时间
            isOpen:{type:Sequelize.INTEGER, allowNull: true, defaultValue: 0}, //是否启用该时间段配置（0-否，1-是）
            updated_by:{type:Sequelize.STRING(255)}, //最后修改人
            updated_at:{type:Sequelize.DATE}, //最后修改时间
        },
        association: []
    }
];