/**
 * 表统一管理
 */


export const TablesConfig = {}

export let EccTableConfig = {};


function initEccTableConfig() {
    for(let tableChName in TablesConfig) {
        let {tableName, schema} = TablesConfig[tableChName];
        EccTableConfig[tableName] ={};
        

        for (let filesName in schema) {
            let valueType = typeof schema[filesName];
            let value = schema[filesName];
            EccTableConfig[tableName][filesName] = {type:'', notMustHave:false};
            if (valueType == "function") {
                EccTableConfig[tableName][filesName].type = value.name;
            } else if (valueType == "object") {
                if (!value.type) {
                    EccTableConfig[tableName][filesName].type = `[${value[0].name}]`;
                   
                } else {
                    if (typeof value.type == "function") {
                        EccTableConfig[tableName][filesName].type = value.type.name
                    } else EccTableConfig[tableName][filesName].type = `[${value.type[0].name}]`;
                    if (value.index) EccTableConfig[tableName][filesName].notMustHave = true;
                }
            }
        }
        
    }
    console.log('table eccConfig init success');
}

initEccTableConfig();