/**
 * 公智能评价答题
 */

import asyncHandler from 'express-async-handler';
import * as questionBiz from '../biz/question';
import * as authenticationBiz from '../biz/authentication';
import { checkUser } from '../middleware/user';

export function setRouter(httpServer) {
    /**单点登录 */
    httpServer.post('/gzn/sso/verify', asyncHandler(authenticationBiz.checkSession));

    /**答题 */
    httpServer.post('/gzn/question/checkanswered', checkUser, asyncHandler(checkStudentHasAnswered));
    httpServer.post('/gzn/question/getppeningtime', checkUser, asyncHandler(getFirstOpeningTimeConfig));
    httpServer.post('/gzn/question/setopeningtime', checkUser, asyncHandler(setOpeningTimeConfig));
    httpServer.post('/gzn/question/answer', checkUser, asyncHandler(questionsByDirection));
    httpServer.post('/gzn/question/completeanswer', checkUser, asyncHandler(completeAnswer));
    httpServer.post('/gzn/question/finishanswer', checkUser, asyncHandler(finishAnswer));
    httpServer.post('/gzn/question/answerresult', checkUser, asyncHandler(answerResultWithLionImage));

    /**管理答题记录 */
    httpServer.post('/gzn/admin/allanswerrecords', checkUser, asyncHandler(allStudentAnswerRecords));
    httpServer.post('/gzn/admin/studentdetailed', checkUser, asyncHandler(studentDetailed));
    httpServer.post('/gzn/admin/batchstudentdetailed', checkUser, asyncHandler(batchStudentDetailed));
}


/**
 * 判断学生是否重复答题
 * @param req 
 * @param res 
 */
async function checkStudentHasAnswered(req, res) {
    const UserInfo = req.userInfo;
    let result = await questionBiz.checkStudentHasAnswered(UserInfo.studentId);
    res.success(result);
}


/**
 * 服务时间配置回显
 * @param req 
 * @param res 
 */
async function getFirstOpeningTimeConfig(req, res) {
    const userInfo = req.userInfo;
    let result = await questionBiz.getFirstOpeningTimeConfig();
    res.success(result);
}


/**
 * 创建或更新服务时间配置
 * @param req 
 * @param res 
 */
async function setOpeningTimeConfig(req, res) {
    const UserInfo = req.userInfo;
    let {startTime, endTime, isOpen, name, otId} = req.body;
    let result = await questionBiz.setOpeningTimeConfig(startTime, endTime, isOpen, name, otId);
    res.success(result);
}



// async function checkIsInOpeningTime(req, res) {
//     const UserInfo = req.userInfo;
//     let {}
// }




/**
 * 题目
 * @param req 
 * @param res 
 */
async function questionsByDirection(req, res) {
    const UserInfo = req.userInfo;
    let result = await questionBiz.getQuestionsByDirection(); 
    res.success(result);
}


/**
 * 批量完成答题接口
 * @param req UserInfo.studentName
 * @param res 
 */
async function completeAnswer(req, res) {
    const UserInfo = req.userInfo;
    let {studentName, answers} = req.body;
    let result = await questionBiz.completeAnswerBatch(UserInfo.studentId, studentName, answers);
    res.success(result);
}


/**
 * 完成全部答题
 * @param req 
 * @param res 
 */
async function finishAnswer(req, res) {
    const UserInfo = req.userInfo;
    let {record_id} = req.body;
    let result = await questionBiz.finishAnswer(record_id);
    res.success(result);
}


/**
 * 获取测评得分以及狮子形象
 * @param req 
 * @param res 
 */
async function answerResultWithLionImage(req, res) {
    const UserInfo = req.userInfo;
    let {record_id} = req.body;
    let result = await questionBiz.getAnswerResultWithLionImage(record_id);
    res.success(result);
}

//管理员页面 ==============================================================================================

/**
 * 获取所有学生答题记录及详细得分
 * @param req 
 * @param res 
 */
async function allStudentAnswerRecords(req, res) {
    const UserInfo = req.userInfo;
    let {page} = req.body;
    let result = await questionBiz.getAllStudentAnswerRecordsOptimized(page);
    // let result = await questionBiz.getAllStudentAnswerRecords();
    res.success(result);
}


/**
 * 单个答题记录数据下载
 * @param req 
 * @param res 
 */
async function studentDetailed(req, res) {
    const UserInfo = req.userInfo;
    let {record_id} = req.body;
    let result = await questionBiz.getStudentDetailed(record_id);
    res.success(result);
}


/**
 * 批量答题记录数据下载
 * @param req 
 * @param res 
 */
async function batchStudentDetailed(req, res) {
    const UserInfo = req.userInfo;
    let {record_id} = req.body;
    let result = await questionBiz.getBatchStudentDetailed(record_id);
    res.success(result);
}




