import { ERRORENUM } from "../config/errorEnum";
import { systemConfig } from "../config/serverConfig";
import { EccTableConfig } from "../config/mongoTableConfig";
import { BizError } from "../util/bizError";
import { mysqlModelMap } from "../model/sqlModelBind";
import { selectOneDataByParam } from "../data/findData";
import { TABLENAME } from "../config/dbEnum";

/**
 * 中间件 校验连接对象token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkMongoSign(req, res, next) {
    if (!req.headers) req.headers = {};

    let sign = req.headers.sign;
    let table = req.headers.table;

    if (sign != systemConfig.sign) return next( new BizError(ERRORENUM.身份验证失败, `传入的sign值为:${sign}`) );
    if (!table) return next( new BizError(ERRORENUM.缺少必要参数_表名, `传入的table值为:${table}`) );
    
    if (!EccTableConfig[table]) return next( new BizError(ERRORENUM.不存在表, `传入的table值为:${table}`) );
    next();
}


/**
 * 中间件 校验连接对象token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkMySqlSign(req, res, next) {
    if (!req.headers) req.headers = {};

    let sign = req.headers.sign;
    let table = req.headers.table;

    if (sign != systemConfig.sign) return next( new BizError(ERRORENUM.身份验证失败, `传入的sign值为:${sign}`) );
    if (!table) return next( new BizError(ERRORENUM.缺少必要参数_表名, `传入的table值为:${table}`) );
    
    if (!mysqlModelMap[table]) return next( new BizError(ERRORENUM.不存在表, `传入的table值为:${table}`) );
    req.tableModel = mysqlModelMap[table];

    next();
}


export async function checkUser(req, res, next) {
    if (!req.headers) req.headers = {};
    const userId = req.headers.userid || "";
    const reqToken = req.headers.token || "";

    if (!userId) return next(new BizError(ERRORENUM.身份验证失败, `studentId:${userId} token:${reqToken}`));
    
    let userDbData:any = await selectOneDataByParam(TABLENAME.管理后台用户, {loginId:userId}, ["loginId", "token"]);
    if (!userDbData || !userDbData.data || !userDbData.data.loginId) return next(new BizError(ERRORENUM.非法登录, `userId:${userId} token:${reqToken}`));

    if (userDbData.data.token != reqToken) return next(new BizError(ERRORENUM.身份验证失败, `studentId:${userId} `));

    const userName = req.headers.username || "";
    req.userInfo = {
        studentId:userId,
        studentName:userName
    }

    next();
}

