import { initConfig, systemConfig} from "./config/serverConfig";
import * as mysqlDB from "./db/mysqlInit";
import { initMysqlModel } from "./model/sqlModelBind";
import { httpServer } from "./net/http_server";
import { initUACIntegration } from './biz/UAC';
import { BackupService } from './biz/dataBackup';


async function lanuch() {
    /**初始化配置解析 */
    await initConfig();
    /**初始化数据库 */
    // await mongoDB.initDB();
    // await initModel();
    /**初始化sql */
    await mysqlDB.initMysqlDB();
    await initMysqlModel();
    /**创建http服务 */
    httpServer.createServer(systemConfig.port);

    console.log('This indicates that the server is started successfully.');

    backup();

    // 应用启动时初始化UAC集成
    const xmlRpcServer = await initUACIntegration();
    if (xmlRpcServer) {
        console.log('🟢 XML-RPC服务器启动成功，正在监听端口:', systemConfig.xmlRpcServer.port);
    } else {
        console.error('🔴 XML-RPC服务器启动失败');
    }
}

lanuch();


function backup() {
    const backupService = new BackupService({
        host: systemConfig.mysqldb.host,
        user: systemConfig.mysqldb.user,
        password: systemConfig.mysqldb.pwd,
        database: systemConfig.mysqldb.dataBase,
        localBackupPath: './nm_backups', // 本地临时备份路径
        remoteBackupPath: '/mnt/nm_gzn/backups', // 远程服务器备份路径
        remoteHost: '123.207.147.179', //远程服务器ip
        remoteUser: 'root', //远程服务器用户名
        remotePassword: 'GNIWT20110919!@@@', // 远程服务器密码
        sshPort: 22, // SSH端口
        retentionDays: 30,
        keepLocalBackup: true
    });
      
    // 先进行测试
    backupService.testBackup()
    .then(() => {
        console.log('启动定时备份（每天凌晨2:00执行）');
        // 启动定时备份（每天凌晨2:00执行）
        backupService.startScheduledBackup(2, 0);
    })
    .catch(error => {
        console.error('备份配置测试失败，请检查配置:', error);
    });

    // 也可以立即执行一次备份
    // backupService.backupNow()
    // .then(result => console.log('立即备份完成:', result))
    // .catch(error => console.error('立即备份失败:', error));
}





