// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import router from './router'
import ElementUI from 'element-ui'
import NProgress from 'nprogress'
import VueI18n from 'vue-i18n'
import Axios from 'axios'
import 'element-ui/lib/theme-chalk/index.css'
import store from './store/store'
Vue.config.productionTip = false
import VueCookie  from 'vue-cookie'
import 'nprogress/nprogress.css'
import LangZHCN from './lang/zh-cn'
import LangENUS from './lang/en-us'
import LangJAJP from './lang/ja-jp'
import LangKPKR from './lang/ko-kr'
import md5 from 'js-md5'
import $ from 'jquery'

Vue.use(ElementUI);
Vue.use(VueCookie);
Vue.use(VueI18n);

let lang = !sessionStorage.getItem('lang') || sessionStorage.getItem('lang') == "undefined" ? 'zh-cn' : sessionStorage.getItem('lang');
const i18n = new VueI18n({
  locale: lang,
  messages: {
    'en-us': LangENUS,
    'zh-cn': LangZHCN,
    'ko-kr': LangKPKR,
    'ja-jp': LangJAJP
  }
});

// changeLange();

// function changeLange () {
//   i18n.locale = sessionStorage.getItem('lang') ? sessionStorage.getItem('lang') : 'zh-cn'
// }
// console.log("lang",vue.i18n);


Date.prototype.format = function(fmt)   
{ //author: meizz   
  var o = {   
    "M+" : this.getMonth()+1,                 //月份   
    "d+" : this.getDate(),                    //日   
    "h+" : this.getHours(),                   //小时   
    "m+" : this.getMinutes(),                 //分   
    "s+" : this.getSeconds(),                 //秒   
    "q+" : Math.floor((this.getMonth()+3)/3), //季度   
    "S"  : this.getMilliseconds()             //毫秒   
  };   
  if(/(y+)/.test(fmt))   
    fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));   
  for(var k in o)   
    if(new RegExp("("+ k +")").test(fmt))   
  fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));   
  return fmt;   
}

// 设置请求token
Axios.interceptors.request.use(config => {
  let token = sessionStorage.getItem('token')
  let user = JSON.parse(sessionStorage.getItem('user'));
  config.headers['token'] = token;
  if (user) config.headers['userid'] = user.id;
  return config
})

// 接口错误拦截
Axios.interceptors.response.use(res => {
  return res?res.data:res

  // if (res.status === 401) {
  //   app && app.$message({
  //     type: 'warning',
  //     message: '登录身份过期，请重新登录。'
  //   })
  //   sessionStorage.removeItem('token')
  //   sessionStorage.removeItem('user')
  //   router.push({name: 'login'})
  //   return Promise.reject(new Error('身份过期'))
  // } 
  // else if (res.status == 500){
  //   app.$notify.error({
  //     title: '服务错误',
  //     message: '服务器响应错误 ' + JSON.stringify(res.data)
  //   })
  // }
  // else {
  //   return res?res.data:res
  // }
}, err => {
  let errinfo = {
    title: '服务错误',
    message: ' 服务器响应错误 '
  }
  return Promise.reject(errinfo)
})


//导航卫士
router.beforeEach((to, from, next) => {
  // NProgress.start();
  // let token = sessionStorage.getItem('token');
  // if (!token && to.name !== 'login') {
  //   // app && app.$message.error('未授权，请登陆授权后继续')
  //   // NProgress.done();
  //   return next({name: 'login'})
  // }
  return next();
});

Vue.prototype.$http = Axios
Vue.http = Axios
Vue.prototype.$md5 = md5;


/* eslint-disable no-new */
var vue = new Vue({
  el: '#app',
  router,
  i18n,
  store,
  components: { App },
  template: '<App/>'
});

export default vue
