import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)

export default new Router({
  mode: 'history',
  routes: [{
      path: '/',
      name: 'login',
      component: () => import('../pages/home.vue')
    },
    {
      path: '/new',
      name: 'new',
      component: () => import('../pages/new/menu.vue')
    },
    {
      path: '/login',
      name: 'login',
      component: () => import('../pages/login.vue')
    },
    {
      path: '/home', 
      name: 'home',
      component: () => import('../pages/home.vue'),
      children: [
        {path: 'notebook', name: 'notebook', component: () => import('../pages/self/notebook.vue')}
      ]
    },
    {
      path: '/project',
      name: 'project',
      component: () => import('../pages/home.vue'),
      children: [
        {path: 'projectList', name: 'projectList', component: () => import('../pages/project/projectList.vue')},
        {path: 'taskList', name: 'taskList', component: () => import('../pages/task/taskList.vue')},
        {path: 'initiate', name: 'initiate', component: () => import('../pages/task/initiate.vue')},
      ]
    },
    {
      path: '/set',
      name: 'set',
      component: () => import('../pages/home.vue'),
      children: [
        {path: 'pwd', name: 'pwd', component: () => import('../pages/set/pwd.vue')},
      ]
    },
    {
      path: '/boss',
      name: 'boss',
      component: () => import('../pages/home.vue'),
      children: [
        {path: 'createProject', name: 'createProject', component: () => import('../pages/boss/createProject.vue')},
        {path: 'stats', name: 'stats', component: () => import('../pages/boss/stats.vue')},

      ]
    },
    {
      path: '/pm',
      name: 'pm',
      component: () => import('../pages/home.vue'),
      children: [
        {path: 'replenish', name: 'replenish', component: () => import('../pages/pm/replenish.vue')},
        {path: 'stats', name: 'stats', component: () => import('../pages/pm/stats.vue')},

      ]
    },{
      path: '/new',
      name: 'new',
      component: () => import('../pages/home.vue'),
      children: [
        {path: 'menu', name: 'menu', component: () => import('../pages/new/menu.vue')},
      ]
    }

  ]
});

