/**
 * 零碎的通用工具
 */

import moment = require("moment");

/**
 * 匹配新旧对象变化
 * 将newObj 与 oldObj 比对，将newObj中发生变化的key返回
 * 使用前需要校验对象中的内容
 * @param newObj 新对象
 * @param oldObj 旧对象
 * @returns [key] 发生变化的key
 */
export function checkChange(newObj, oldObj) {
    let changeKeyList = [];
    for (let newKey in newObj) {
        if (`${newObj[newKey]}` != `${oldObj[newKey]}`) changeKeyList.push(newKey);
    }
    return changeKeyList;
}

/**
 * 根据conf截取data中的数据
 * @param conf 
 * @param data 
 * @returns 
 */
export function extractData(conf, data, isAdmin) {
    let result = {};
    for (let key in conf) {
        let confInfo = conf[key];
        if (confInfo.changeDate) {
            if (isAdmin) result[key] = data[key] ? moment(data[key]).format("YYYY-MM-DD") : '-';
            else result[key] = data[key] || 0;
        } else if (confInfo.isAdd && isAdmin) {
            let addStr = "";
            data[key].forEach(str => {
                addStr += str;
            });
            result[key] = addStr;
        }
        else {
            result[key] = data[key];
            if (typeof result[key] == 'string' && !result[key]) result[key] = '';
        }
    }
    return result;
}


/**
 * 校验数据对象是否有空
 * @param data 
 * @param sensitive  敏感校验  true时  0 和 ""会校验失败  false时 校验成功
 * @returns true/false true = 有空值   false=无空值
 */
export function checkDataHaveNull(data:object, sensitive:boolean) {
    if (Array.isArray(data)) return data.length == 0;
    if (Object.keys(data).length == 0) return true;
    
    let success = false;
    for (let key in data) {
        if (data[key] == null || data[key] == undefined) success = true;
        if (sensitive) {
            if (data[key] === 0 || data[key] === "" ) success = true;
        }
    }
    return success;
}


/**
 * 将枚举值转换成对应的枚举名(key)
 * @param enumConf 目标枚举
 * @param value 目标值
 * @returns string  返回字符串 如果传入多个枚举值，就拼接字符串
 */
export function changeEnumValue(enumConf, value:any) {
    if (!value) return '';
    if ( typeof value == 'number' ) {
        return enumConf[value];
    }
    let str = "";
    value.forEach((item, index) => {
        str += enumConf[item];
        if (index == value.length-1) str+="";
        else str += ","
    });

    return str;
}
