import moment = require("moment");
const md5 = require("md5");

/**
 * 生成工时填报的dateKey
 * @returns 
 */
export function generateDateKey(time?) {
    if (time) {
        return moment(time).format("YYYY-MM-DD")+ ' 18:00:00';
    }
    return moment().format("YYYY-MM-DD")+ ' 18:00:00'
}

/**
 * 生成请假的id
 * @param userId 
 * @returns 
 */
export function generateAskForLeaveId(userId:number) {
    return `al${userId}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`
}

export function getClientTime(time:string) {
    return moment(time).format("YYYY/MM/DD HH:mm");
}

export function getDBTime(time?) {
    if (!time) return moment().format("YYYY-MM-DD HH:mm:ss");
    return moment(time).format("YYYY-MM-DD HH:mm:ss");
}

/**
 * 生成加班填报的id
 * @param userId 
 * @returns 
 */
export function getOvertimeId(userId:number) {
    return `ot${userId}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`
}


/**
 * 获取token
 * @param loginId 登录id
 */
export function getToken(loginId:string) {
    return md5(`${loginId}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 生成工时填报的id
 * @param userId 
 * @returns 
 */
export function getWorkingLogId(userId:number) {
    return `wl${userId}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`
}