/**
 * 工时路由
 */

import asyncHandler = require('express-async-handler');
import * as workingLogBiz from '../biz/workingLog';
import { checkFuHuaQiToken } from '../middleware/user';
import { eccEnumValue, eccReqParamater } from '../tools/eccParam';
import { WORKLOGADMINTYPE } from '../config/enum';
import { getDepartmentUserList } from '../biz/member';

export function setRouter(httpServer) {
    httpServer.post('/workinglog/find', checkFuHuaQiToken, asyncHandler(find));
    httpServer.post('/workinglog/add', checkFuHuaQiToken, asyncHandler(add));
    httpServer.post('/workinglog/del', checkFuHuaQiToken, asyncHandler(del));
    httpServer.post('/workinglog/update', checkFuHuaQiToken, asyncHandler(update));
    /**工时管理 */
    httpServer.post('/workinglog/admin/list', checkFuHuaQiToken, asyncHandler(workginLogAdminList));
    httpServer.post('/workinglog/admin/outputlist', checkFuHuaQiToken, asyncHandler(outPutList));
    /**部门主管看的列表 */
    httpServer.post('/workinglog/department/list', checkFuHuaQiToken, asyncHandler(departmentWorkLogList));
    httpServer.post('/workinglog/department/userlist', checkFuHuaQiToken, asyncHandler(departmentUserList));
}

/**
 * 工时管理列表
 * @param req 
 * @param res 
 */
async function workginLogAdminList(req, res) {
    let  reqConf = {page: 'Number', type:'Number', startMs:'String', endMs:"String"};
    let { page, type, startMs, endMs } = eccReqParamater(reqConf, req.body, ['startMs', 'endMs'] );

    eccEnumValue("工时管理列表", type, WORKLOGADMINTYPE, type);
    
    let result:any = {};
    if (type == WORKLOGADMINTYPE.按时间分) result = await workingLogBiz.adminWorkLogForTime(page, startMs, endMs);
    else result = await workingLogBiz.adminWorkLogForProject(page, startMs, endMs);
    result.type = type;

    res.success(result);
}


/**
 * 导出 工时管理列表 
 * @param req 
 * @param res 
 */
async function outPutList(req, res) {
    let  reqConf = {type:'Number', startMs:'String', endMs:"String"};
    let { type, startMs, endMs } = eccReqParamater(reqConf, req.body, ['startMs', 'endMs'] );
    eccEnumValue("工时管理列表", type, WORKLOGADMINTYPE, type);

    let result:any = {};
    if (type == WORKLOGADMINTYPE.按时间分) result = await workingLogBiz.outPutAdminWorkingLogListForTime(startMs, endMs);
    else result = await workingLogBiz.outPutAdminWorkingLogListForProject(startMs, endMs);

    res.success(result);
}


/**
 * 工时管理 查询填报的工时
 * @param req 
 * @param res 
 */
async function find(req, res) {
    let userId = req.headers.userid;
    let result = await workingLogBiz.workinglogList(userId);
    res.success(result);
}


/**
 * 
 * @param req 工时管理 添加
 * @param res 
 */
async function add(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {time: 'Number', projectId: 'String', isOutside: 'Boolean', date:'String', workLog:"String"};
    let { time, projectId, isOutside, date, workLog} = eccReqParamater(reqConf, req.body, ['workLog']);
    // let { time, projectId, isOutside, date} = req.body;

    let result = await workingLogBiz.addWorking(userId, time, projectId, isOutside, date, workLog);
    res.success(result);
}


/**
 * 工时管理 删除
 * @param req 
 * @param res 
 */
async function del(req, res) {
    let userId = req.headers.userid;
    let { id } = req.body;
    let result = await workingLogBiz.delWorkinglog(userId, id);
    res.success(result);
}


/**
 * 工时管理 修改
 * @param req 
 * @param res 
 */
async function update(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {id:"String", time: 'Number', projectId: 'String', isOutside: 'Boolean', workLog:"String"};
    let {id, time, projectId, isOutside, workLog} = eccReqParamater(reqConf, req.body, ['workLog']);

    let result = await workingLogBiz.updateWorkinglog(userId, id, time, projectId, isOutside, workLog);
    res.success(result);
}


async function departmentWorkLogList(req, res) {
    let  reqConf = {departmentId:"Number", startTime:"String", endTime:"String", userId:"Number", page:"Number", projectId:"String"};
    let {departmentId, startTime, endTime, userId, page, projectId} = eccReqParamater(reqConf, req.body, ['startTime','endTime', 'userId', 'projectId']);

    let result = await workingLogBiz.departmentWorklog(departmentId, startTime, endTime, userId, page, projectId);
    res.success(result);
}

async function departmentUserList(req, res) {
    let  reqConf = {departmentId:"Number"};
    let {departmentId} = eccReqParamater(reqConf, req.body, []);

    let result = await getDepartmentUserList(departmentId);
    res.success(result);
}

