/**
 * 用户路由
 */

import asyncHandler = require('express-async-handler');
import * as userBiz from '../biz/user';
import { checkFuHuaQiToken } from '../middleware/user';
import { eccReqParamater } from '../tools/eccParam';

export function setRouter(httpServer) {
    httpServer.post('/user/login', asyncHandler(login));
    httpServer.post('/user/logout', asyncHandler(logout));
}


async function login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let userInfo = await userBiz.login(loginId, pwd);

    res.success(userInfo);
}


async function logout(req, res) {
    let userId = req.headers.userid;

    let userInfo = await userBiz.logout(userId);

    res.success(userInfo);
}
