/**
 * 用户
 */

import { DEPARTMENTENUM, FIRSTLVLIMIT, ROLEENUM, SECONDLVLIMIT, TABLENAMEENUM } from "../config/enum";
import { ERRORENUM } from "../config/errorEnum";
import { selectOneDataByParam } from "../model/findData";
import { updateManyData } from "../model/updateData";
import { BizError } from "../util/bizError";
import { getToken } from "../util/myTools";


/**
 * 登陆
 * @param loginId 
 * @param pwd 
 * @returns 
 */
export async function login(loginId:string, pwd:number) {
    let userInfo = await selectOneDataByParam(TABLENAMEENUM.用户表, {loginId}, [] );
    if (!userInfo.userId) throw new BizError(ERRORENUM.登录失败, '用户不存在');
    if (userInfo.pwd != pwd) throw new BizError(ERRORENUM.密码错误, `密码错误 ${pwd}`);

    let token = getToken(userInfo.loginId);

    await updateManyData(TABLENAMEENUM.用户表, {loginId}, {token});

    let stagingList = [];
    let approveList = [];
    let statsList = [];//统计
    if (userInfo.departmentId == DEPARTMENTENUM.开发 || userInfo.departmentId == DEPARTMENTENUM.设计 ||userInfo.departmentId == DEPARTMENTENUM.项目经理) {
        stagingList = [FIRSTLVLIMIT.工时填报, FIRSTLVLIMIT.加班填报, FIRSTLVLIMIT.请假填报];
        if (userInfo.roleId == ROLEENUM.部门经理) {
            stagingList.push(FIRSTLVLIMIT.数据导出);
            stagingList.push(FIRSTLVLIMIT.部门工时列表)
            statsList = [SECONDLVLIMIT.工时统计, SECONDLVLIMIT.部门统计];
            if (userInfo.departmentId != DEPARTMENTENUM.项目经理) approveList = [FIRSTLVLIMIT.加班审批, FIRSTLVLIMIT.请假审批];
        }
    } else if (userInfo.departmentId == DEPARTMENTENUM.领导) {
        stagingList = [FIRSTLVLIMIT.请假审批, FIRSTLVLIMIT.数据导出];
        statsList = [SECONDLVLIMIT.工时统计, SECONDLVLIMIT.部门统计];
    } else if (userInfo.departmentId == DEPARTMENTENUM.行政 ) {
        stagingList = [FIRSTLVLIMIT.加班审批, FIRSTLVLIMIT.数据导出, FIRSTLVLIMIT.立项];
    } else if (userInfo.departmentId == DEPARTMENTENUM.人事) {
        stagingList = [FIRSTLVLIMIT.人事用请假情况, FIRSTLVLIMIT.请假审批, FIRSTLVLIMIT.出勤, FIRSTLVLIMIT.成员列表];
    }

    let result = { token, 
        userId:userInfo.userId, 
        roleId:userInfo.roleId, 
        departmentId:userInfo.departmentId, 
        name:userInfo.name,
        headSculpture:`http://192.168.0.109:7088/1.png`,
        stagingList,
        approveList,
        statsList
    };

    return result;
}


/**
 * 退出登陆
 * @param userId 
 * @returns 
 */
export async function logout(userId:number) {
    let userInfo = await selectOneDataByParam(TABLENAMEENUM.用户表, {userId}, [] );
    if ( !userInfo.userId ) throw new BizError(ERRORENUM.身份验证失败);
    await updateManyData(TABLENAMEENUM.用户表, {userId}, {token:""});

    return {isSuccess:true}
}

export async function changePwd() {
    
}
