/**
 * 放系系统基础数据
 */

import { DEPARTMENTENUM, ROLEENUM, SYSTEMCONSTCONFIGENUM, SYSTEMSETKEY, TABLENAMEENUM } from "../config/enum";
import { addData } from "../model/addData";
import { selectOneDataByParam } from "../model/findData";
import moment = require("moment");

export let queue = {
   
};

export async function initSystemConst() {
    /**部门经理 */
    queue[SYSTEMCONSTCONFIGENUM.部门经理] = {};

    let userInfo = await selectOneDataByParam(TABLENAMEENUM.用户表, {roleId:ROLEENUM.部门经理,departmentId:DEPARTMENTENUM.开发 }, ["userId", "name"]);
    queue[SYSTEMCONSTCONFIGENUM.部门经理][DEPARTMENTENUM.开发] = {userId:userInfo.userId, name:userInfo.name};
    
    userInfo = await selectOneDataByParam(TABLENAMEENUM.用户表, {roleId:ROLEENUM.部门经理,departmentId:DEPARTMENTENUM.设计 }, ["userId", "name"])
    queue[SYSTEMCONSTCONFIGENUM.部门经理][DEPARTMENTENUM.设计] = {userId:userInfo.userId, name:userInfo.name};

    userInfo = await selectOneDataByParam(TABLENAMEENUM.用户表, {roleId:ROLEENUM.部门经理,departmentId:DEPARTMENTENUM.项目经理 }, ["userId", "name"])
    queue[SYSTEMCONSTCONFIGENUM.部门经理][DEPARTMENTENUM.项目经理] = {userId:userInfo.userId, name:userInfo.name};

    queue[SYSTEMCONSTCONFIGENUM.加班默认] = {userId:17, name:"张谕"};
    queue[SYSTEMCONSTCONFIGENUM.请假默认] = {userId:16, name:"万仪停"};

    /**初始化系统配置 */
    let askMsInfo = await selectOneDataByParam(TABLENAMEENUM.系统设置表, {id:SYSTEMSETKEY.年假重置时间}, ["id", "value"]);
    if (!askMsInfo || !askMsInfo.id ) {
        await addData(TABLENAMEENUM.系统设置表, {id:SYSTEMSETKEY.年假重置时间, value:moment().format("YYYY-MM-DD")+" 00:00:00", desc:"年假重置时间"});
    }
}