/**
 * 统计主要逻辑
 */

import moment = require("moment");
import { APPROVETYPE, DEPARTMENTENUM, TABLENAMEENUM } from "../config/enum";
import { selectDataListByParam, selectDataToTableAssociation } from "../model/findData";
import { getDBTime } from "../util/myTools";


/**
 * 统计所有项目的部门消耗
 * @returns 
 */
export async function allProjectData() {
    let projectDBList = await selectDataListByParam(TABLENAMEENUM.项目表, {}, ["projectId", "name"]);
    let projectMap = {};
    projectDBList.forEach(info => {
        projectMap[info.projectId] = info.name;
    });
    /**计算工时 */
    let includeConf = {};
    includeConf[TABLENAMEENUM.用户表] = ["name", "departmentId" ];
    /**加班 */
    let overtimeDBList = await selectDataToTableAssociation(TABLENAMEENUM.加班, includeConf, {state:APPROVETYPE.通过}, ["projectId", "userId", "time" ]);
    let map = {};
    overtimeDBList.forEach(info => {
        let {projectId, user, time} = info;
        let {departmentId} = user;
        if (!map[projectId]) map[projectId] = {};
        if (!map[projectId][departmentId]) map[projectId][departmentId] = 0;
        map[projectId][departmentId] += time;
    });
    /**工时 */
    includeConf[TABLENAMEENUM.项目表] = ["name"];
    let column = ["dateKey", "time", "isOutside", "projectId"];
    let wlDBList = await selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf, {}, column );

    
    wlDBList.forEach(info => {
        let {time, projectId, user} = info;
        let {departmentId} = user;
        if (!map[projectId]) map[projectId] = {};
        if (!map[projectId][departmentId]) map[projectId][departmentId] = 0;
        map[projectId][departmentId] += time;
    });

    let projectList = [];
    for (let projectId in map) {
        let info = map[projectId];
        let ui = parseInt(info[DEPARTMENTENUM.设计] || 0);
        let dev = parseInt(info[DEPARTMENTENUM.开发] || 0);
        let pm = parseInt(info[DEPARTMENTENUM.项目经理] || 0);
        projectList.push({
            ui, dev, pm, 
            count:ui+dev+pm,
            projectName:projectMap[projectId],
        });
    }
    projectList.sort((a,b) => {return b.count - a.count});

    let ui = [];
    let dev = [];
    let pm = [];
    let projectNameList = [];
    let pieChartList = [];
    const PieChartDataCount = 8;
    projectList.forEach((info, index) => {
        ui.push(info.ui);
        dev.push(info.dev);
        pm.push(info.pm);
        projectNameList.push(info.projectName);
        
        if (index < PieChartDataCount) {
            pieChartList.push({name:info.projectName, value:info.count});
        } else {
            if (!pieChartList[PieChartDataCount]) pieChartList.push({name:"其他", value:info.count});
            else pieChartList[PieChartDataCount].value += info.count;
        }
    });

    return { ui, dev, pm, projectNameList, pieChartList };
}


/**
 * 统计时间内的所有项目的部门消耗
 * @param st 
 * @param et 
 * @returns 
 */
export async function timeProjectData(st:string, et:string) {
    let selectParam:any = {};
    if (st && et) {
        selectParam.dateKey = {"%between%":[moment(st).format("YYYY-MM-DD") + ' 00:00:00', moment(et).format("YYYY-MM-DD") + ' 23:59:59']};
    }

    let projectDBList = await selectDataListByParam(TABLENAMEENUM.项目表, {}, ["projectId", "name"]);
    let projectMap = {};
    projectDBList.forEach(info => {
        projectMap[info.projectId] = info.name;
    });
    /**计算工时 */
    let includeConf = {};
    includeConf[TABLENAMEENUM.用户表] = ["name", "departmentId" ];
    /**加班 */
    let overtimeDBList = await selectDataToTableAssociation(TABLENAMEENUM.加班, includeConf, Object.assign({state:APPROVETYPE.通过}, selectParam), ["projectId", "userId", "time" ]);
    let map = {};
    overtimeDBList.forEach(info => {
        let {projectId, user, time} = info;
        let {departmentId} = user;
        if (!map[projectId]) map[projectId] = {};
        if (!map[projectId][departmentId]) map[projectId][departmentId] = 0;
        map[projectId][departmentId] += time;
    });
    /**工时 */
    includeConf[TABLENAMEENUM.项目表] = ["name"];
    let column = ["dateKey", "time", "isOutside"];
    let wlDBList = await selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf, selectParam, column );

    
    wlDBList.forEach(info => {
        let {time, projectId, user} = info;
        let {departmentId} = user;
        if (!map[projectId]) map[projectId] = {};
        if (!map[projectId][departmentId]) map[projectId][departmentId] = 0;
        map[projectId][departmentId] += time;
    });

    let projectList = [];
    for (let projectId in map) {
        let info = map[projectId];
        let ui = parseInt(info[DEPARTMENTENUM.设计] || 0);
        let dev = parseInt(info[DEPARTMENTENUM.开发] || 0);
        let pm = parseInt(info[DEPARTMENTENUM.项目经理] || 0);
        projectList.push({
            ui, dev, pm, 
            count:ui+dev+pm,
            projectName:projectMap[projectId],
        });
    }
    projectList.sort((a,b) => {return b.count - a.count});

    let ui = [];
    let dev = [];
    let pm = [];
    let projectNameList = [];
    let pieChartList = [];
    const PieChartDataCount = 8;
    projectList.forEach((info, index) => {
        ui.push(info.ui);
        dev.push(info.dev);
        pm.push(info.pm);
        projectNameList.push(info.projectName);
        
        if (index < PieChartDataCount) {
            pieChartList.push({name:info.projectName, value:info.count});
        } else {
            if (!pieChartList[PieChartDataCount]) pieChartList.push({name:"其他", value:info.count});
            else pieChartList[PieChartDataCount].value += info.count;
        }
    });

    return { ui, dev, pm, projectNameList, pieChartList };
}


/**
 * 部门工时消耗统计-人员应填统计统计
 * @param departmentId 
 * @returns 
 */
export async function departmentWorkinglogData(departmentId:number) {
    let thisDepartmentUserList = await selectDataListByParam(TABLENAMEENUM.用户表, {departmentId}, ["name"]);

    let startTime = moment().format("YYYY-MM")+'-01 00:00:00';

    let includeConf = {};
    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ], where:{departmentId}};
    let column = ["userId", "time", "isOutside"];
    let workLogDBList = await selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf, {dateKey:{"%gt%":startTime} }, column );

    let worklogMap = {};
    workLogDBList.forEach(info => {
        let {user, time} = info;
        let {name} = user;
        if (!worklogMap[name]) worklogMap[name] = 0;
        worklogMap[name] += time;
    });

    let nowMs = new Date(moment().format("YYYY-MM-DD")+' 00:00:00').valueOf();
    
    /**算应填的时间 */
    let workDayCount = 0;
    for (let i = 0; i < moment().daysInMonth(); i++) {
        let ms = moment(startTime).add(i, 'days').valueOf();
        let weekDay = moment(ms).day();
        if (weekDay <=5 && weekDay !=0) {
            workDayCount += 8;
        }
        if (ms == nowMs) break;
    }

    let completedList = []
    let notCompletedList = [];
    let nameList = [];
    thisDepartmentUserList.forEach(info => {
        let {name} = info;
        let time = worklogMap[name] || 0;
        
        completedList.push(time);
        notCompletedList.push(workDayCount - time);
        nameList.push(name);
    });

    return {completedList, notCompletedList, nameList};

}


export async function departmentAskForLeaveAndOverTimeData(departmentId:number) {
    let selectTime = moment().format("YYYY-MM")+'-01 00:00:00';

    let memberDistinctMap = {}

    let includeConf = {};
    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ], where:{departmentId}};
    let column = ["userId", "time"];
    let workLogDBList = await selectDataToTableAssociation(TABLENAMEENUM.加班, includeConf, {dateKey:{"%gt%":selectTime} }, column );
    let overtimeDataMap = {};
    workLogDBList.forEach(info => {
        let {user, time} = info;
        let {name} = user;
        if (!overtimeDataMap[name]) overtimeDataMap[name] = 0;
        overtimeDataMap[name] += time;
        memberDistinctMap[name] = 1;
    });

    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ], where:{departmentId}};
    column = ["day", "time"];
    let askDBList = await selectDataToTableAssociation(TABLENAMEENUM.请假, includeConf, {startTime:{"%lt%":selectTime}, endTime:{"%gt%":selectTime} }, column );
    let askForLeaveMap = {};
    askDBList.forEach(info => {
        let {user, time, day} = info;
        let {name} = user;
        if (!askForLeaveMap[name]) askForLeaveMap[name] = 0;
        askForLeaveMap[name] += parseInt(time) + (parseInt(day) * 8 );
        memberDistinctMap[name] = 1;
    });
    
    let overTimeList = []
    let askForLeaveList = [];
    let nameList = [];

    for (let name in memberDistinctMap) {
        let overTime = overtimeDataMap[name] || 0;
        let askForLeaveTime = askForLeaveMap[name] || 0;
        
        overTimeList.push(overTime);
        askForLeaveList.push(askForLeaveTime);
        nameList.push(name);
    }
    return { overTimeList, askForLeaveList, nameList };
}

export async function departmentProjectData(departmentId:number) {
    let selectTime = moment().format("YYYY-MM")+'-01 00:00:00';

    let includeConf = {};
    includeConf[TABLENAMEENUM.项目表] = ["name"];
    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ], where:{departmentId}};
    let column = ["userId", "time", "isOutside"];
    let dbList = await selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf,{dateKey:{"%gt%":selectTime} }, column );

    let dataMap = {};
    dbList.forEach(info => {
        let {project, time, user} = info;
        if (!dataMap[project.name]) dataMap[project.name] = {};
        if (!dataMap[project.name][user.name]) dataMap[project.name][user.name] = 0;
        dataMap[project.name][user.name] += parseInt(time);
    });

    let dataList = [];
    for (let name in dataMap) {
        let addInfo = {name, children:[]};
        for (let userName in dataMap[name]) {
            let value = dataMap[name][userName];
            let key = `${userName}(${value})`;
            addInfo.children.push({
                name:key,
                value
            });
        }
        dataList.push(addInfo);
    }

    return { dataList };
}

export async function departmentProjectCalendarData(departmentId:number) {
    let selectTime = moment().format("YYYY-MM")+'-01 00:00:00';
    let thisTime = getDBTime();

    let includeConf = {};
    includeConf[TABLENAMEENUM.项目表] = ["name"];
    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ], where:{departmentId}};
    let column = ["userId", "time", "isOutside", "dateKey"];
    let dbList = await selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf,{dateKey:{"%between%":[selectTime, thisTime]} }, column );

    let dataMap = {};
    let distinctMap = {};
    dbList.forEach(info => {
        let {project, time, dateKey} = info;
        distinctMap[project.name] = 1;
        let key = moment(dateKey).format("YYYY-MM-DD");
        if (!dataMap[key]) dataMap[key] = {};
        if (!dataMap[key][project.name]) dataMap[key][project.name] = 0;
        dataMap[key][project.name] += parseInt(time);
    });

    let nowMs = new Date(moment().format("YYYY-MM-DD")+' 00:00:00').valueOf();
    let dataList = [];
    let scatterData = [];
    for (let i = 0; i < moment().daysInMonth(); i++) {
        let ms = moment(selectTime).add(i, 'days').valueOf();
        let dateKey = moment(ms).format("YYYY-MM-DD");
        if (ms < nowMs) {
            let onceData = dataMap[dateKey];
            let data = [];
            for (let projectName in onceData) {
                data.push({name:projectName, value:onceData[projectName]});
            }
            dataList.push({center:dateKey, data });
        } else {
            dataList.push({center:dateKey, data:[] });
        }
        scatterData.push([dateKey]);
    }
    let month = moment().format("YYYY-MM");

    return {dataList, projectList:Object.keys(distinctMap), month, scatterData}
}

export async function getThisMonthProject(projectName:string, departmentId:number) {
    let selectTime = moment().format("YYYY-MM")+'-01 00:00:00';
    let includeConf = {};
    includeConf[TABLENAMEENUM.项目表] = {column:["name"], where:{name:projectName}}
    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ], where:{departmentId}};
    let column = ["userId", "time", "isOutside", "workLog"];
    let dbList = await selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf,{dateKey:{"%gt%":selectTime} }, column );

    let dataList = [];
    dbList.forEach(info => {
        let {project, dateKey, workLog, time} = info; 
        dataList.push({name:project.name, date:moment(dateKey).format("YYYY-MM-DD"), workLog, time});
    });
    return {dataList}
}


export async function getThisMonthProjectAndName(projectName:string, departmentId:number, userName:string) {
    let selectTime = moment().format("YYYY-MM")+'-01 00:00:00';
    let includeConf = {};
    includeConf[TABLENAMEENUM.项目表] = {column:["name"], where:{name:projectName}}
    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ], where:{departmentId, name:userName}};
    let column = ["userId", "time", "isOutside", "workLog"];
    let dbList = await selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf,{dateKey:{"%gt%":selectTime} }, column );
    let dataList = [];
    dbList.forEach(info => {
        let {user, dateKey, workLog, time} = info; 
        dataList.push({name:user.name, date:moment(dateKey).format("YYYY-MM-DD"), workLog, time});
    });
    return {dataList}
}


export async function test1() {
    let includeConf = {};
    includeConf[TABLENAMEENUM.用户表] = {column: ["name", "userId",  "departmentId" ]};
    let column = ["userId", "time", "day", "dateKey", "startTime", "endTime","des", "type"];
    let workLogDBList = await selectDataToTableAssociation(TABLENAMEENUM.请假, includeConf, {state:1 }, column );
    // let overtimeDataMap = {};
    // let memberDistinctMap = {};
    workLogDBList.forEach(info => {
        let {user, time, dateKey, workLog, project} = info;
        let {name} = user;
        // if (!overtimeDataMap[name]) overtimeDataMap[name] = [];
        // overtimeDataMap[name].push({});
        // memberDistinctMap[name] = 1;
    });


    console.log();
}



